#ifndef HEADER_ARM
#define HEADER_ARM

#include <cstdint>
#include <cmath>

class Arm {
  public:

  int i;
  double idx;
  double reward;
  double reward_squared;
  uint64_t T;

  double mean() {
    return (T == 0)?0.0:(reward / T);
  }

  double var() {
    return (T == 0)?0.0:(reward_squared/T - pow(mean(), 2.0));
  }

  bool operator<(const Arm &b)const {
    return idx < b.idx;
  }
  bool operator>(const Arm &b)const {
    return idx > b.idx;
  }
  Arm(int i, double idx) {
    this->i = i;
    this->idx = idx;

    T = 0;
    reward = 0.0;
  }
};



#endif
