 function [adj,sigma,inferred_sigma,overlap] = demo_sbm(N,q,cin,cout,seed,method)
 	% Spectral clustering using various methods on graphs generated by the stochastic block model
 	% INPUTS :
 	% N is the number of nodes (will be rounded to a multiple of the number of communities)
 	% q is the number of communities
 	% cin is the average intra-community connectivity
 	% cout is the average extra-community connectivity
 	% seed is the seed of the random number generator
 	% method is a string that can be either :
 	% - 'BH' : clustering with the Bethe Hessian
 	% - 'B' : clustering with the the non-backtracking matrix
 	% - 'A' : clustering with the adjacency matrix
 	% - 'Lap' : clustering with the symmetrically normalized laplacian
    % OUTPUTS :
    % adj is the adjacency matrix of the graph that was generated 
    % sigma is the true community assignement of the nodes 
    % inferred_sigma is the community assignement inferred by the spectral clustering method 
    % overlap is the overlap (as defined in the paper) between the inferred community assignement and the real one 
    % Example : [adj,sigma,inferred_sigma,overlap]=demo_sbm(1e5,2,5,1,1,'BH');
    

    path(path,'./subroutines/');
    if(nargin~=6)
    	usage;
        error('type help demo_sbm for a description');
    end

    [adj,sigma]=sbm_gen(N,q,cin,cout,seed);

    warning('off','MATLAB:eigs:NoEigsConverged');
    warning('off','MATLAB:eigs:NotAllEigsConverged');
    warning('off','stats:kmeans:FailedToConvergeRep');

    
    if(strcmp(method,'BH'))
    	[inferred_sigma,overlap]=BH_cluster(adj,sigma,q,cin-cout);
    elseif(strcmp(method,'B'))
    	[inferred_sigma,overlap]=Bprime_cluster(adj,sigma,q);
    elseif(strcmp(method,'A'))
    	[inferred_sigma,overlap]=A_cluster(adj,sigma,q,cin-cout);
    elseif(strcmp(method,'Lap'))
    	[inferred_sigma,overlap]=Lap_cluster(adj,sigma,q,cin-cout); 		
    end

    fprintf('Clustering with %s, an overlap of %f was found\n',method,overlap);

end
