function centers = biggridsphere( sz )
% centers = biggridsphere( sz )
%  Generates a grid on the surface of a unit spehre
%  code due to user 'Paul' on fileexchange/28842-gridsphere
%
% Inputs:
%  - sz: size of the grid
%
% Outputs:
%  - centers, 3x? matrix: grid on the sphere of size at least sz

[lat,long]=GridSphere(sz);
latrad=deg2rad(lat);
longrad=deg2rad(long);
[x,y,z]=sph2cart(longrad,latrad,1);
centers=[x,y,z]';
end

