function x = optimize_kl(p,c,b,x)
% minimize sum(-p.*log(x)) + c'*x s.t. b'*x == 1
% solves via Newton's method

n = size(p,1);
if (nargin < 4), x = ones(n,1)./(b*n); end
beta = 0.8;
alpha = 1e-4;
gamma = 1e-5;
iter = 1;

while (1)
  iter = iter + 1;
  f = -sum(p.*log(x)) + c'*x + gamma/2*(x'*x);
  g = -p./x + c + gamma*x;
  hi = 1 ./ (p./(x.^2) + gamma);
  dnu = -(b'*(g.*hi))/(b'*(b.*hi));
  dx = -(g + b*dnu).*hi;
  lambda = norm(dx ./ sqrt(hi));
  %lambda = sum(dx.^2./hi);
  if (lambda^2 < 1e4*eps || iter > 50), break; end
  
  % backtracking line search (first make sure x stays positive)
  t = 1.0;
  while (max(x + t*dx <= 0) == 1),
    t = beta * t; 
  end

  xn = x + t*dx;
  while(-sum(p.*log(xn)) + c'*xn + gamma/2*(xn'*xn) > f + alpha*t*(g'*dx))
    t = beta * t;
    xn = x + t*dx;
  end
  x = xn;
  x = x ./ (b'*x);
end
  
  
  