P = 0.5*ones(2,2);
gamma = 0.99;
epsilon = 0.001;

Phi = [1; 1.05 + epsilon];
%R = ones(2,1)*(1-gamma);
%V = (eye(2) - gamma*P) \ R;
V = [1; 1.05];
R = (eye(2) - gamma*P)*V;

err_D = []; err_mu = [];
for p=[0:0.0001:1],
  D = diag([p 1-p]);
  V_td = Phi*((Phi'*D*(Phi - gamma*P*Phi)) \ (Phi'*D*R));
  V_pi = Phi*(Phi \ V);

  err_mu(end+1,:) = [p sqrt((V_td - V)'*diag([0.5 0.5])*(V_td - V)) ...
    sqrt((V_pi - V)'*diag([0.5 0.5])*(V_pi - V)) ...
    min(eig([Phi'*D*Phi Phi'*D*P*Phi; Phi'*P'*D*Phi Phi'*D*Phi]))];
end

clf;

i = find(err_mu(:,4) < 0, 1);
semilogy(err_mu(:,1), err_mu(:,2), 'LineWidth', 2, 'Color', [0 0 1]);
hold on;
semilogy(err_mu(:,1), err_mu(:,3), 'LineWidth', 2, 'Color', [0 0.5 0]);


%h=patch([0 0 err_mu(i-1,1) err_mu(i-1,1)],[get(gca,'YLim') fliplr(get(gca,'YLim'))], [0 0 0 0], [0.8 0.8 0.8]);
%hold on;
%semilogy(err_mu(:,1), err_mu(:,2), err_mu(:,1), err_mu(:,3), '--', 'LineWidth', 2);
%legend('TD Solution', 'Optimal Approximation', 'Feasible Region');

