%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% get_gauss_cond_entropy:
%
% Get conditional entropy of y given parents for a Gaussian model with
% covariance V_all.
%
% Input:
%
% - y: target variable
% - parents: conditioning set
% - V_all: covariance of the Gaussian model
%
% Output:
%
% - value: the conditional entropy
%
% Created by: Ricardo Silva, London, 12/05/2011
% University College London
% Current version: 12/05/2011

function value = get_gauss_cond_entropy(y, parents, V_all)

x_subset = parents;
y_subset = [y x_subset];
entropy_yx = log(det(V_all(y_subset, y_subset)));
entropy_x  = log(det(V_all(x_subset, x_subset)));
value = 0.5 * (log(2 * pi) + 1 + entropy_yx - entropy_x);
    
