/*---------------------------------------------------
 * File:    graph.h
 * purpose: header file for the graph struct
 * author:  ahollowa@uci.edu
 * date:    12/11/2009
 *-------------------------------------------------*/

#ifndef _GRAPH_H_
#define _GRAPH_H_

typedef struct{
	struct node *nodes;  // Array of nodes
	int next_avail_id;   // Next available slot in the array
	int capacity;        // Capacity of the node array

	int **equivalence;   // The equivalence classes: A K x L matrix
	int *num_equiv;      // The number of nodes in each equivalence class
	int *limit_equiv;    // A limit on the number of nodes at each level
	int equiv_capacity;  // DEPRECATED: Should be set to K (don't really need this anymore)	
	
	int **adjacency;     // DEPRECATED: Adjacency matrix of original graph
	int *sum_adj;        // DEPRECATED: Not really sure if I need to keep this updated
	
	int max_depth;       // Maximum depth of the graph;	

} Graph;


/* Allocate memory for a graph struct */
Graph *allocate_graph();

/* Increase capacity of nodes */
struct node *increase_nodes_capacity(struct node *nodes_array, int capacity);

/* Print the graph */
void print_graph(Graph *graph, char *outfile);

/* Add a new node to the graph */
void add_new_node(Graph *graph, int add_id, int equiv_class, int L, int W, int D);

/* Delete node from graph */
void delete_node(Graph *graph, int delete_id);

/* Update next_avail_id. Increase graph size if needed */
void update_next_avail_id(Graph *graph);


#endif
