% Generate a synthetic data set on the 10d unit hypercube.

clear;

% Parameters.
seed           = 0;
num_data       = 200;
noise_variance = 0.09;
gain           = 1.0;
jitter         = 1e-9;
num_dims       = 10;
gpml_covs      = {'covSum', {'covSEard', 'covNoise'}};


% Fix random seed.
rand('state', seed);
randn('state', seed);

length_scales = sqrt(num_dims)*rand([num_dims 1]);
theta_log     = log([ length_scales ; gain ; jitter ]);

% Generate the input points.
data.X = rand([num_data num_dims]);
  
% Generate the true function.
K      = feval(gpml_covs{:}, theta_log, data.X);
U      = chol(K);
data.Y = U'*randn([num_data 1]) + sqrt(noise_variance)*randn([num_data 1]);
  
save('data/synthetic.mat');
