function [idl,L]=ransel(label,class,per)
%
%  ransel: conducts stratified sampling, i.e., randomly select a subset of
%          objects from each class as labeled objects
%             
%  Input: 
%       label-a vector containing all the true class labels of the target set
%
%       class-the number of classes in the problem, the class labels must
%             be from 1 to the number of classes
%
%       per-number of objects selected from each class
%
%  Output:         
%
%       idl-the row numer of the labeled objects in the target set
%
%       L-the class labels of the labeled objects
%

% start with empty set
idl=[];

% for each class, randomly pick a subset of objects
for j=1:class
cind=find(label==j);
csize=length(cind);
randind=randperm(csize);
idl=[idl;cind(randind(1:per))];
end

% get the labels of the selected objects
L=label(idl);