function E = init_graphs(E,pause_dt)
% INIT_GRAPHS initializes the graphics
   E.fig   = findobj(0,'Tag','SwimmerWindow');
   
   wh      = 0;

   if  isempty(E.fig) 
      E.fig=figure();
      set(E.fig,'NumberTitle','off','BackingStore','off','Toolbar','None','Menu','none',...
                 'color',wh*[1 1 1],'Tag','SwimmerWindow','Position',[63 203 948 423],'Renderer', 'OpenGL');
   else
      figure(E.fig);
   end
   set(E.fig,'Name', sprintf('%d trajectories of a %d-swimmer, with nose on point %d, viscosity is %2.1g and drag is %2.1g.',E.n_p,E.d,E.nose,E.k1,E.k2));
   clf;
   drawnow;
   E.h1     = subplot(1,2,1);     
                          
   E.Gnose     = ring(12,0,0.1+0.01*E.cScale,1e-6,1e-6,[1 0 0]);
   set(E.Gnose,'user',{get(E.Gnose,'Xdata'), get(E.Gnose,'Ydata'), get(E.Gnose,'Zdata')});
   E.Gtarget   = ring(12,0.1+0.01*E.cScale,0.2+0.02*E.cScale,-1e-6,-1e-6,[0 0.8 0]);
   E.tXYZ      = {get(E.Gtarget,'Xdata'), get(E.Gtarget,'Ydata'), get(E.Gtarget,'Zdata')};
   set(E.Gtarget,'user',[0; 0],'Tag','Target');
   if    isfield(E, 'cScale'), lim  = E.cScale; 
   else  lim  = 5+E.d/2;  end
   ticks   = linspace(-lim+lim/3,lim-lim/3,5);
   set(E.h1,'XLim',lim*[-1 1],'YLim',lim*[-1 1],'Tag','Sim','Xtick',ticks,'Ytick',ticks,'Box','on',...
      'PlotBoxAspectRatio',[1 1 1],'DrawMode','fast','UserData',0,'XtickLabel',[],'YtickLabel',[],...
      'Color',wh*[1 1 1],'xcolor',(1-wh)*[1 1 1],'ycolor',(1-wh)*[1 1 1],'zcolor',(1-wh)*[1 1 1]);
   title('Learned Trajectories','Color','w');
   grid on
   
   for i=1:E.d
      E.Glines(i)=line(0,0,'LineWidth',2);
   end   
   
   E.h2        = subplot(1,2,2);
   E.TJcm      = mean(E.Nlocs,2);
   NNlocs      = E.Nlocs - E.TJcm*ones(1,size(E.Nlocs,2));
 
   [v,e]       = eig(cov((diag([0; 0; ones(3*E.d,1)])*E.Nlocs(:,1:round(0.7*size(E.locs{1},2))))'));
   [e,ix]      = sort(diag(e),'descend');
   E.v1        = v(:,ix(3))';
   E.v2        = v(:,ix(2))';
   E.v3        = v(:,ix(1))';

   TJix = cumsum([0 cellfun('size',E.locs,2)]);
  
   grid on;
   camproj perspective;
   light;
   sc      = 4.5;
   ticks   = linspace(-sc,sc,5);
   set(E.h2,'Xlim',[-1 1]*sc,'Ylim',[-1 1]*sc,'Zlim',[-1 1]*sc,'Xtick',ticks,'Ytick',ticks,'Ztick',ticks,...
           'PlotBoxAs',[1 1 1],'Color',wh*[1 1 1],'xcolor',(1-wh)*[1 1 1],'ycolor',(1-wh)*[1 1 1],'zcolor',(1-wh)*[1 1 1],... 
           'XtickLabel',[],'YtickLabel',[],'ZtickLabel',[]);
   view(130,10);
   camva(25);
   set(E.h2,'CameraPos',get(E.h2,'CameraPos')*0.37); 
   
   h2_title = text(0,0,sc+2.5,'State Space (projected)','Color','w','HorizontalAlignment','center','VerticalAlignment','top');
                        % 2.5
   origin   = [[0;0] E.xJump];

   Gskip = uicontrol('Style', 'togglebutton', 'String', 'Skip','Value',0,...
                  'ForegroundColor', (1-wh)*[1 1 1],'BackgroundColor',get(gcf,'Color'),'Position', [20 15 60 20]);   
   for i = 1:E.n_p
      Traj     = NNlocs(:,TJix(i)+1:TJix(i+1));
      set(E.fig,'CurrentAxes',E.h2);
      lines(i) = patch('Faces',1,'Vertices',[nan nan nan],'FaceVertexCData',nan,...
               'EdgeColor',hsv2rgb([i/E.n_p 1 0.8]),'FaceColor','flat','EdgeAlpha',0.4,'LineWidth',2.5); 
      for t = 1:TJix(i+1)-TJix(i)
         tic;
         set(E.fig,'CurrentAxes',E.h2);
         if get(Gskip,'Value')
            set(lines(i),'Faces',[1:TJix(i+1)-TJix(i)+1],'Vertices',[Traj(:,1:TJix(i+1)-TJix(i))'*[E.v1;E.v2;E.v3]'; [nan nan nan]]);
            break;
         end
         set(lines(i),'Faces',[1:t+1],'Vertices',[Traj(:,1:t)'*[E.v1;E.v2;E.v3]'; [nan nan nan]]);
         set(E.Gtarget,'Xdata',E.tXYZ{1}-origin(1,i),'Ydata',E.tXYZ{2}-origin(2,i),'Zdata',E.tXYZ{3});
         draw_swimmer(E,[E.locs{i}(1:2,t)-origin(:,i); E.locs{i}(3:end,t)],E.locs{i}(:,t),nan);
         drawnow;
         pause(max(pause_dt-toc,0));
      end 
   end        
   delete(Gskip);
   set(E.fig,'CurrentAxes',E.h2);
   [x,y,z]  = sphere(6); 
   E.gs     = 0.35; 
   E.Gstate = surface(E.gs*x,E.gs*y,E.gs*z,cat(3,ones(6),zeros(6),ones(6)),'EdgeColor','none','FaceL','gour','CDataM','dir');   
   alpha(E.Gstate,1);   
   E.Gwinner= surface(E.gs*x,E.gs*y,E.gs*z,cat(3,ones(6),ones(6),zeros(6)),'EdgeColor','none','FaceL','gour','CDataM','dir');
   alpha(E.Gwinner,1);        
   light;
   
   set(h2_title,'String',{'\color{white}State Space (projected)';...
                          '\color[rgb]{1 0 1}\bullet current state             ';...
                          '\color[rgb]{1 1 0}\bullet nearest neighbor        '});   
   set(E.fig,'CurrentAxes',E.h1);
   title('Mechanical Simulation','Color','w');
   E.Gstop     = uicontrol('Style', 'pushbutton', 'String', 'Select','UserData',0,...
                  'ForegroundColor', (1-wh)*[1 1 1],'BackgroundColor',get(gcf,'Color'),'Position', [20 15 60 20], 'Callback', @bStop);                                                                                           
   E.Grestart  = uicontrol('Style', 'pushbutton', 'String', 'Restart','UserData',1,...
                  'ForegroundColor', (1-wh)*[1 1 1],'BackgroundColor',get(gcf,'Color'),'Position', [90 15 60 20], 'Callback', @bRestart); 
   E.Grotate   = uicontrol('Style', 'pushbutton', 'String', 'Rotation','UserData',0,...
                  'ForegroundColor', (1-wh)*[1 1 1],'BackgroundColor',get(gcf,'Color'),'Position', [160 15 60 20], 'Callback', @bRotate);             
   uicontrol('Style', 'pushbutton', 'String', 'About','ForegroundColor', (1-wh)*[1 1 1],'BackgroundColor',get(gcf,'Color'),...
                                                                                       'Position', [230 15 60 20], 'Callback', @bAbout);
   set(E.fig,'WindowButtonDownFcn',@bDown); 
   set(E.fig,'WindowButtonUpFcn',  @bUp);    
   E.Gtime     = uicontrol(E.fig,'Style', 'CheckBox','String','Jumping target','Position', [300 15 106 20], ...
                            'BackgroundColor',get(gcf,'Color'),'ForegroundColor', (1-wh)*[1 1 1],...
                            'HorizontalAlignment'   , 'left','FontSize', 10);   
   E.Glimit    = uicontrol(E.fig,'Style', 'CheckBox','String','Hard Limiting','Position', [410 15 105 20], ...
                            'BackgroundColor',get(gcf,'Color'),'ForegroundColor', (1-wh)*[1 1 1],...
                            'HorizontalAlignment'   , 'left','FontSize', 10);    
   
   function bDown(src,evnt)
      h = findobj(src,'Tag','Sim');
      if ~isempty(h)
         set(src,'WindowButtonMotionFcn',@bMove);
         cp = get(h,'CurrentPoint');  
         cp = cp(1,1:2)'+[-0.25; 0.25];
         set(findobj(h,'Tag','Target'),'Xdata',E.tXYZ{1}+cp(1),'Ydata',E.tXYZ{2}+cp(2),...
                       'Zdata',E.tXYZ{3},'user',cp);
      end
      function bMove(src,evnt)
         h = findobj(src,'Tag','Sim');
         if ~isempty(h)
            cp = get(h,'CurrentPoint');  
            cp = cp(1,1:2)'+[-0.25; 0.25];
            
            set(findobj(h,'Tag','Target'),'Xdata',E.tXYZ{1}+cp(1),'Ydata',E.tXYZ{2}+cp(2),...
                          'Zdata',E.tXYZ{3},'user',cp);      
         end
      end
   end
   function bUp(src,evnt)
      h = findobj(src,'Tag','Sim');
      if ~isempty(h)
         set(src,'WindowButtonMotionFcn','');
      end
   end
   function bStop(src,event)
      set(E.Gstop,'UserData',1);
   end
   function bRestart(src,event)
      set(E.Grestart,'UserData',1);
   end
   function bRotate(src,event)
      if get(E.Grotate,'userdata')
         set(E.Grotate,'UserData',0);
      else
         set(E.Grotate,'UserData',1);
      end
   end
   function bAbout(src,event)
      cs.WindowStyle='modal';
      cs.Interpreter='tex';
      msgbox({'\fontsize{9}Demonstration of the alogrithm described in the paper',...
              '\color[rgb]{.8 0 0}Receding Horizon Differential Dynamic Programming',...
              '\color{black}by Tassa, Erez & Smart, NIPS 2007.',...
              'MATLAB package: Yuval Tassa.'},'About','help',cs)      
   end
   function rh = ring(n,r1,r2,z1,z2,color)
      tt    = linspace(0,2*pi,n);
      X     = [r1*cos(tt) r2*cos(tt)];
      Y     = [r1*sin(tt) r2*sin(tt)];
      Z     = [z1*ones(1,n) z2*ones(1,n)];
      tri   = [[(1:n)' (n+1:2*n)' [2*n (n+1:2*n-1)]'];[(1:n)' [(2:n) 1]' (n+1:2*n)']];

      rh = patch('faces',tri,'vertices',[X(:) Y(:) Z(:)],...
               'FaceColor',color,'EdgeColor','none');
   end
end


   