use scallop_codegen::scallop;

scallop! {
  ConstInHead {
    decl student(Int, String).
    decl course(Int, String).
    decl enroll(Int, Int).
    decl students_in_cis_500(String).

    student(1, "alice").
    student(2, "bob").
    student(3, "catherine").

    course(1, "cis-500").
    course(2, "cis-515").
    course(3, "cis-548").

    enroll(1, 1).
    enroll(1, 3).
    enroll(2, 2).
    enroll(3, 1).
    enroll(3, 2).

    students_in_cis_500(N) :- student(SID, N), course(CID, "cis-500"), enroll(SID, CID).
  }
}

fn main() {
  let mut prog = ConstInHead::<()>::new();

  // Execute the program
  prog.run();

  // Investigate the results
  for elem in prog.students_in_cis_500().complete().into_iter() {
    println!("{:?}", elem);
  }
}
