import os
import sys
sys.path.append(os.path.realpath('.'))
import toy.ops as ops
import matplotlib.pyplot as plt
import numpy as np
import torch

Ts = [0.2, 0.5, 1.0, 2.0, 5.0]
rho = 0.05
x_range = 15.0

x = torch.linspace(-x_range, x_range, 10000)

fig = plt.figure(figsize=(8, 6))
plt.subplots_adjust(left=0.13, right=0.98, bottom=0.13, top=0.95)

l = len(Ts)

for i, (T) in enumerate(Ts):
    q_eff_correct = ops.f_eff_GD(x, (x > 0).to(x.dtype), rho, T, iter=10000)
    plt.plot(
        x, q_eff_correct, linestyle='solid', color='C{:d}'.format(i), label='{:.02f}'.format(T)
    )

    if rho < 1.0:
        q_eff_wrong = ops.f_eff_GD(x, (x < 0).to(x.dtype), rho, T, iter=1000)
        plt.plot(x, q_eff_wrong, linestyle='--', color='C{:d}'.format(i))

plt.xlabel(r'$z_\mathrm{t}$', fontdict={'size': 20})
plt.ylabel(r'$z_\mathrm{eff,s}$', fontdict={'size': 20})

plt.legend(
    loc='best',
    title=r'$T$',
    fontsize=18,
    title_fontsize=18,
)

plt.tick_params(labelsize=20)

plt.title('vary temperature', fontdict={'size': 20})

fig.savefig('./figure/01b.pdf', format='pdf')
