function O=ACCELGOSSIP(x,W,K)
[n,n0]=size(W);
eigens=sort(eig(W));
lambda_max=eigens(n);
lambda_min=eigens(2);

gamma=lambda_min/lambda_max;
c2=(1+gamma)/(1-gamma);
c3=2/(lambda_max+lambda_min);
ak_old=1;
ak=c2;
xk_old=x;
xk=c2*x*(eye(n)-c3*W);

for k=1:K-1
   ak_new=2*c2*ak-ak_old;
   xk_new=2*c2*xk*(eye(n)-c3*W)-xk_old;
   xk_old=xk;
   xk=xk_new;
   ak_old=ak;
   ak=ak_new;
end

O=x-1./ak*xk;

end