#!/bin/bash


data_root=data
exp_name_pre=experiment_wmt14_pre
exp_name=experiment_wmt14


python train.py \
	-data $data_root/wmt14_en_fr.low \
	-save_model $exp_name/wmt14_model \
	-gpu_ranks 0 \
	--batch_size 1 \
	--learning_rate 0.05 \
	--accum_count 32 \
	--enc_layer 1 \
	--dec_layer 1 \
	--src_word_vec_size 620 \
	--tgt_word_vec_size 620 \
	--enc_rnn_size 1000 \
	--dec_rnn_size 1000 \
	--rnn_type GRU \
	--optim adadelta \
	--start_decay_steps 20000 \
	--decay_steps 10000 \
	--train_steps 100000 \
	--topk 0 \
	--soft_topk 5 \
	--teacher_forcing_ratio 0.8 \
	--topk_iter 100 \
	--epsilon 0.05 \
	--train_from $exp_name_pre/wmt14_model_step_1000000.pt \
	--resume_to_retrain \
	--reset_optim all \
	--valid_batch_size 1


