#!/bin/bash


export CUDA_VISIBLE_DEVICES=0

data_root=data
exp_name=experiment_wmt14_pre

python train.py \
	-data $data_root/wmt14_en_fr.low \
	-save_model $exp_name/wmt14_model \
	-gpu_ranks 0 \
	--world_size 1 \
	--batch_size 20 \
	--accum_count 4 \
	--enc_layer 1 \
	--dec_layer 1 \
	--src_word_vec_size 620 \
	--tgt_word_vec_size 620 \
	--enc_rnn_size 1000 \
	--dec_rnn_size 1000 \
	--rnn_type GRU \
	--optim adadelta  \
	--start_decay_steps 500000 \
	--decay_steps 100000  \
	--train_steps 1000000 \
	--topk 5 \
	--soft_topk 0 \
	--teacher_forcing_ratio 1. 







