function M = constantfactory(A)
% Returns a manifold struct representing the singleton.
%
% function M = constantfactory(A)
%
% Given an array A, returns M: a structure describing the singleton {A} as
% a zero-dimensional manifold suitable for Manopt. The only point on M is
% the array A, and the only tangent vector at A is the zero-array of the
% same size as A.
%
% This is a helper factory which can be used to fix certain values in an
% optimization problem, in conjunction with productmanifold.
%
% See also: productmanifold euclideanfactory

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, March 15, 2018.
% Contributors: 
% Change log:
    
    M.name = @() 'Singleton manifold';
    
    M.dim = @() 0;
    
    M.inner = @(x, d1, d2) 0;
    
    M.norm = @(x, d) 0;
    
    M.dist = @(x, y) 0;
    
    M.typicaldist = @() 0;
    
    M.proj = @(x, d) zeros(size(A));
    
    M.egrad2rgrad = @(x, g) zeros(size(A));
    
    M.ehess2rhess = @(x, eg, eh, d) zeros(size(A));
    
    M.tangent = M.proj;
    
    M.exp = @(x, d, t) A;
    
    M.retr = M.exp;
    
    M.log = @(x, y) zeros(size(A));

    M.hash = @(x) 'z1';
    
    M.rand = @() A;
    
    M.randvec = @(x) zeros(size(A));
    
    M.lincomb = @matrixlincomb;
    
    M.zerovec = @(x) zeros(size(A));
    
    M.transp = @(x1, x2, d) zeros(size(A));
    
    M.pairmean = @(x1, x2) A;
    
    M.vec = @(x, u_mat) u_mat(:);
    M.mat = @(x, u_vec) reshape(u_vec, dimensions_vec);
    M.vecmatareisometries = @() true;

end
