# Inverting Gradients - How easy is it to break Privacy in Federated Learning?

## Code
The central file that contains the reconstruction algorithm can be found at ```inversefed/reconstruction_algorithms.py```. The other folders and files are used to define and train the various models and are not central for recovery.

### Setup:
Requirements:
```
pytorch=1.4.0
torchvision=0.5.0
```
You can use [anaconda](https://www.anaconda.com/distribution/) to install our setup by running
```
conda env create -f environment.yml
conda activate iv
```
To run ImageNet experiments, you need to download ImageNet and provide its location [or use your own images and skip the ```inversefed.construct_dataloaders``` steps].


### Quick Start
Usage examples can be found in the notebooks, for example the ResNet-152 example.
Given an input gradient (as computed by e.g. ```torch.autograd.grad```), a ```config``` dictionary, a model ```model``` and dataset mean and std, ```(dm, ds)```, build the reconstruction operator
```
rec_machine = inversefed.GradientReconstructor(model, (dm, ds), config, num_images=1)
```
and then start the reconstruction, specifying a target image size:
```
output, stats = rec_machine.reconstruct(input_gradient, None, img_shape=(3, 32, 32))
```



### CLI Usage example:
The code can be used via cmd-line in the following way:
```
python reconstruct_image.py --model ResNet20-4 --dataset CIFAR10 --trained_model --cost_fn sim --indices def --restarts 32 --save_image --target_id -1
```
This can be used to replicate the experiments shown in the paper.