# -*- coding: utf-8 -*-

# In this code, we test on Friedman1 with linear regression. 

# load packages
import numpy as np
import sklearn
import pandas as pd
import random
import matplotlib.pyplot as plt
import math
from sklearn.linear_model import LinearRegression
from sklearn.ensemble.gradient_boosting import GradientBoostingRegressor
from sklearn import datasets
from sklearn.tree import DecisionTreeRegressor
from sklearn import preprocessing
from sklearn import neural_network
from sklearn.neural_network import MLPRegressor

from numpy import savetxt
from numpy import genfromtxt
from sklearn.ensemble.forest import RandomForestRegressor



## 

def al():
  ## for player A testing
 size_vali = 10000
 x_vali,y_vali = datasets.make_friedman1(n_samples=size_vali, n_features=5, noise=1)
 #y_vali = mu + np.random.normal(0,1,size_vali)
 x_vali = pd.DataFrame(x_vali)
 A1 = x_vali.iloc[:,[0,1,4]]
 B1 = x_vali.iloc[:,[3]]
 C1 = x_vali.iloc[:,[2]]
 error_toa = []
 error_toa1 = []
 oracle = []
 size = 1000
 for h in range(10):
    print(h)
    ##training data
    X,y = datasets.make_friedman1(n_samples=size, n_features=5, noise=1)
    X = pd.DataFrame(X)
    A = X.iloc[:,[0,1,4]]
    B = X.iloc[:,[3]]
    C = X.iloc[:,[2]]
    reg = LinearRegression().fit(X,y)
    #print('oracle', reg.coef_)
    res = y_vali - reg.predict(x_vali)
    oracle.append(np.linalg.norm(res)/np.sqrt(size_vali))
    print(np.linalg.norm(res)/np.sqrt(size_vali))
    ##iteration number
    k1 = [0,1,2,3,4,5,6,7,8,9,10]
    error = []
    error1 = []
    for k in k1:
      res = y
      pred_res = [0]*size_vali
      for i in range(k):
         regA =  LinearRegression().fit(A,res)
         pred_res = pred_res + regA.predict(A1)
         resA = res - regA.predict(A)
         regB =  LinearRegression().fit(B,resA)
         pred_res = pred_res + regB.predict(B1)
         resB = resA - regB.predict(B)
         regC =  LinearRegression().fit(C,resB)
         pred_res = pred_res + regC.predict(C1)
         resC = resB - regC.predict(C)
         res = resC
      error.append(np.linalg.norm(y_vali - pred_res)/np.sqrt(size_vali))
      print(np.linalg.norm(y_vali - pred_res)/np.sqrt(size_vali))
      res = y
      pred_res = [0]*size
      for i in range(k):
         regA = LinearRegression().fit(A,res)
         pred_res = pred_res + regA.predict(A)
         resA = res - regA.predict(A)
         regB = LinearRegression().fit(B,resA)
         pred_res = pred_res + regB.predict(B)
         resB = resA - regB.predict(B)
         regC = LinearRegression().fit(C,resB)
         pred_res = pred_res + regC.predict(C)
         resC = resB - regC.predict(C)
         res = resC
      error1.append(np.linalg.norm(y - pred_res)/np.sqrt(size))
      #print(np.linalg.norm(y - pred_res)/np.sqrt(size))
    error_toa1.append(error1)
    error_toa.append(error)
 oracle = np.array(oracle)

 return  error_toa, error_toa1, oracle

def plot_al(error_toa, error_toa1, oracle):
  t1 = np.array(error_toa)
  t2 = np.array(error_toa1)
  std1 = np.std(t1, axis =0)
  std2 = np.std(t2, axis =0)
  k1 = [0,1,2,3,4,5,6,7,8,9,10]
  mean = []
  oracle1 = [oracle.mean()]*len(k1)
  for i in range(len(k1)):
    p = 0
    for k in range(10):
        p = p + (error_toa[k][i])/10
    mean.append(p)
  mean1 = []
  for i in range(len(k1)):
    p = 0
    for k in range(10):
        p = p + (error_toa1[k][i])/10
    mean1.append(p)
  fig = plt.figure(figsize = (10,8))
  plt.plot(k1,mean,c = 'r',label = 'Testing Error', linewidth=4,linestyle = '--')
  plt.plot(k1,mean1,c = 'b',label = 'Training Error',linewidth=4,linestyle = '-.')
  plt.plot(k1,oracle1, c = 'black',label = 'Oracle', linewidth=4, linestyle=':')
  legend = plt.legend(loc='upper right', shadow=True, fontsize='x-large')
  plt.xlabel('Rounds of Assistance',fontsize = 25)
  plt.ylabel('Prediction Error',fontsize = 25)
  font = {'family' : 'normal',
        'weight' : 'normal',
        'size'   : 22}
  plt.rc('font', **font)
  plt.ylim((2.45,2.8))
  plt.fill_between(k1, mean-std1, mean+std1, alpha=0.1, color = 'red')
  plt.fill_between(k1, mean1-std2, mean1+std2, alpha=0.1, color = 'blue')
  #ax.set(xlim=(0,25))
  legend = plt.legend(loc='upper right', shadow=True, fontsize='x-large')
  plt.show()


if __name__ == '__main__':
     train_error, test_error, oracle = al()
     plot_al(train_error, test_error, oracle)





