data=yelp
embeddings="nnlm128 nnlm50 nnlm128_norm nnlm50_norm bert use elmo"

epochs=200
sgd_momentum=0.9
batch_size=64

l2_regs=0.0,0.0001,0.001
sgd_lrs=0.0001,0.001,0.01


for embedding in $embeddings
do
  output_folder="results/$data/fine_tune"
  output_file="$output_folder/$embedding.csv"

  mkdir -p $output_folder

  cmd="python lib/fine_tune_linear.py --features_train=matrices/$data/train/features_$embedding.npy --features_test=matrices/$data/test/features_$embedding.npy --labels_train=matrices/$data/train/labels_$embedding.npy --labels_test=matrices/$data/test/labels_$embedding.npy -v 1 --epochs=$epochs --l2_regs=$l2_regs --sgd_lrs=$sgd_lrs --sgd_momentum=$sgd_momentum --batch_size=$batch_size --output_file=$output_file"

  echo "Running '$cmd'"
  $cmd
done
