data=imdb
embeddings="bow bow_tfidf pca_8 pca_16 pca_32 pca_64 elmo nnlm50 nnlm50_norm nnl128 nnlm128_norm use bert"

epochs=200
sgd_momentum=0.9
batch_size=64

l2_regs=0.0,0.0001,0.001,0.01,0.1
sgd_lrs=0.0001,0.001,0.01,0.1


for embedding in $embeddings
do
  output_folder="results/$data/fine_tune"
  output_file="$output_folder/$embedding.csv"

  mkdir -p $output_folder

  cmd="python lib/fine_tune_linear.py --features_train=matrices/$data/train/features_$embedding.npy --features_test=matrices/$data/test/features_$embedding.npy --labels_train=matrices/$data/train/labels_$embedding.npy --labels_test=matrices/$data/test/labels_$embedding.npy -v 1 --epochs=$epochs --l2_regs=$l2_regs --sgd_lrs=$sgd_lrs --sgd_momentum=$sgd_momentum --batch_size=$batch_size --output_file=$output_file"

  echo "Running '$cmd'"
  $cmd
done
