# MCUNet Models

We provide the MCUNet models in TF-Lite format. The model files are in `models` directory.

 

## Usage

We used TensorFlow 1.15 to evaluate the models. You may replace the `--tflite_path` flag with other models.

1. To test the accuracy of an **ImageNet** model, use the following command:

```bash
python eval.py --tflite_path models/mcunet_imagenet_best.tflite --dataset imagenet --val_dir path/to/imagenet/val 
```

2. To test the accuracy of a **VWW** model, use the following command:

```bash
python eval.py --tflite_path models/mcunet_vww_best.tflite --dataset vww --val_dir path/to/coco 
```

3. To test the accuracy of a **Speech Commands (V2)** model, use the following command (will need to re-format the original dataset structure into `train/val/test` sub-folders):

```bash
python eval.py --tflite_path models/mcunet_gcommands_best.tflite --dataset gcommands --val_dir path/to/gcommands/v2 
```



## Model Performance

All the models provided are co-designed for STM32F746 MCU. They can fit a tight budget of 320kB SRAM and 1MB Flash when running on TinyEngine. The performance is listed below:

| Model                         | Dataset         | Latency Limit | Top-1 Acc. |
| ----------------------------- | --------------- | ------------- | ---------- |
| mcunet_imagenet_best.tflite   | ImageNet        | N/A           | 60.2%      |
| mcunet_imagenet_5fps.tflite   | ImageNet        | 5 FPS         | 49.9%      |
| mcunet_imagenet_10fps.tflite  | ImageNet        | 10 FPS        | 40.5%      |
| mcunet_vww_best.tflite        | VWW             | N/A           | 92.0%      |
| mcunet_vww_5fps.tflite        | VWW             | 5 FPS         | 88.7%      |
| mcunet_vww_10fps.tflite       | VWW             | 10 FPS        | 87.3%      |
| mcunet_gcommands_best.tflite  | Speech Commands | N/A           | 95.9%      |
| mcunet_gcommands_5fps.tflite  | Speech Commands | 5 FPS         | 93.8%      |
| mcunet_gcommands_10fps.tflite | Speech Commands | 10 FPS        | 91.1%      |

