/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import utility.MTRandom;

public class FuncUtils {
    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValueDescending(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                return -compare;
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValueAscending(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                return compare;
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static int nextDiscrete(double[] probs) {
        double sum = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            sum += probs[i];
        }
        double r = MTRandom.nextDouble() * sum;
        sum = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            if (!((sum += probs[i]) > r)) continue;
            return i;
        }
        return probs.length - 1;
    }

    public static double mean(double[] m) {
        double sum = 0.0;
        for (int i = 0; i < m.length; ++i) {
            sum += m[i];
        }
        return sum / (double)m.length;
    }

    public static double stddev(double[] m) {
        double mean = FuncUtils.mean(m);
        double s = 0.0;
        for (int i = 0; i < m.length; ++i) {
            s += (m[i] - mean) * (m[i] - mean);
        }
        return Math.sqrt(s / (double)m.length);
    }

    public static double sum(double[] vector) {
        double sum = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            sum += vector[i];
        }
        return sum;
    }

    public static double[] L1NormWithReusable(double[] vector) {
        double sum = 0.0;
        for (double value : vector) {
            sum += value;
        }
        if (Double.compare(sum, 0.0) > 0) {
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = vector[i] / sum;
            }
        } else {
            return null;
        }
        return vector;
    }

    public static float ComputeCosineSimilarity(float[] vector1, float[] vector2) {
        float denom;
        if (vector1.length != vector2.length) {
            try {
                throw new Exception("DIFER LENGTH");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((denom = FuncUtils.VectorLength(vector1) * FuncUtils.VectorLength(vector2)) == 0.0f) {
            return 0.0f;
        }
        return FuncUtils.InnerProduct(vector1, vector2) / denom;
    }

    public static float computDist(float[] vector1, float[] vector2) {
        return 1.0f - FuncUtils.ComputeCosineSimilarity(vector1, vector2);
    }

    public static float InnerProduct(float[] vector1, float[] vector2) {
        if (vector1.length != vector2.length) {
            try {
                throw new Exception("DIFFER LENGTH ARE NOT ALLOWED");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        float result = 0.0f;
        for (int i = 0; i < vector1.length; ++i) {
            result += vector1[i] * vector2[i];
        }
        return result;
    }

    public static float VectorLength(float[] vector) {
        float sum = 0.0f;
        for (int i = 0; i < vector.length; ++i) {
            sum += vector[i] * vector[i];
        }
        return (float)Math.sqrt(sum);
    }
}

