/*
 * Decompiled with CFR 0.152.
 */
package utility;

import cc.mallet.optimize.Optimizable;
import cc.mallet.types.MatrixOps;

public class TopicVectorOptimizer
implements Optimizable.ByGradientValue {
    int[] wordCount;
    int totalCount;
    int vocaSize;
    double[][] wordVectors;
    double[] topicVector;
    int vectorSize;
    double[] expectedCountValues;
    double l2Constant;
    double[] dotProductValues;
    double[] expDotProductValues;

    public TopicVectorOptimizer(double[] inTopicVector, int[] inWordCount, double[][] inWordVectors, double inL2Constant) {
        int w;
        this.vocaSize = inWordCount.length;
        this.vectorSize = inWordVectors[0].length;
        this.l2Constant = inL2Constant;
        this.topicVector = new double[this.vectorSize];
        System.arraycopy(inTopicVector, 0, this.topicVector, 0, inTopicVector.length);
        this.wordCount = new int[this.vocaSize];
        System.arraycopy(inWordCount, 0, this.wordCount, 0, this.vocaSize);
        this.wordVectors = new double[this.vocaSize][this.vectorSize];
        for (w = 0; w < this.vocaSize; ++w) {
            System.arraycopy(inWordVectors[w], 0, this.wordVectors[w], 0, this.vectorSize);
        }
        this.totalCount = 0;
        for (w = 0; w < this.vocaSize; ++w) {
            this.totalCount += this.wordCount[w];
        }
        this.expectedCountValues = new double[this.vectorSize];
        for (int i = 0; i < this.vectorSize; ++i) {
            for (int w2 = 0; w2 < this.vocaSize; ++w2) {
                int n = i;
                this.expectedCountValues[n] = this.expectedCountValues[n] + (double)this.wordCount[w2] * this.wordVectors[w2][i];
            }
        }
        this.dotProductValues = new double[this.vocaSize];
        this.expDotProductValues = new double[this.vocaSize];
    }

    @Override
    public int getNumParameters() {
        return this.vectorSize;
    }

    @Override
    public void getParameters(double[] buffer) {
        for (int i = 0; i < this.vectorSize; ++i) {
            buffer[i] = this.topicVector[i];
        }
    }

    @Override
    public double getParameter(int index) {
        return this.topicVector[index];
    }

    @Override
    public void setParameters(double[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.topicVector[i] = params[i];
        }
    }

    @Override
    public void setParameter(int index, double value) {
        this.topicVector[index] = value;
    }

    @Override
    public void getValueGradient(double[] buffer) {
        double partitionFuncValue = this.computePartitionFunction(this.dotProductValues, this.expDotProductValues);
        for (int i = 0; i < this.vectorSize; ++i) {
            buffer[i] = 0.0;
            double expectationValue = 0.0;
            for (int w = 0; w < this.vocaSize; ++w) {
                expectationValue += this.wordVectors[w][i] * this.expDotProductValues[w];
            }
            buffer[i] = this.expectedCountValues[i] - (double)this.totalCount * (expectationValue /= partitionFuncValue) - 2.0 * this.l2Constant * this.topicVector[i];
        }
    }

    @Override
    public double getValue() {
        double logPartitionFuncValue = Math.log(this.computePartitionFunction(this.dotProductValues, this.expDotProductValues));
        double value = 0.0;
        for (int w = 0; w < this.vocaSize; ++w) {
            if (this.wordCount[w] == 0) continue;
            value += (double)this.wordCount[w] * this.dotProductValues[w];
        }
        value = value - (double)this.totalCount * logPartitionFuncValue - this.l2Constant * MatrixOps.twoNormSquared(this.topicVector);
        return value;
    }

    public double computePartitionFunction(double[] elements1, double[] elements2) {
        double value = 0.0;
        for (int w = 0; w < this.vocaSize; ++w) {
            elements1[w] = MatrixOps.dotProduct(this.wordVectors[w], this.topicVector);
            elements2[w] = Math.exp(elements1[w]);
            value += elements2[w];
        }
        return value;
    }
}

