/*
 * Decompiled with CFR 0.152.
 */
package models;

import cc.mallet.optimize.InvalidOptimizableException;
import cc.mallet.types.MatrixOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import utility.FuncUtils;
import utility.LBFGS;
import utility.Parallel;
import utility.TopicVectorOptimizer;

public class LFLDA {
    public double alpha;
    public double beta;
    public double alphaSum;
    public double betaSum;
    public int numTopics;
    public int topWords;
    public double lambda;
    public int numInitIterations;
    public int numIterations;
    public List<List<Integer>> corpus;
    public List<List<Integer>> topicAssignments;
    public int numDocuments;
    public int numWordsInCorpus;
    public HashMap<String, Integer> word2IdVocabulary;
    public HashMap<Integer, String> id2WordVocabulary;
    public int vocabularySize;
    public int[][] docTopicCount;
    public int[] sumDocTopicCount;
    public int[][] topicWordCountLDA;
    public int[] sumTopicWordCountLDA;
    public int[][] topicWordCountLF;
    public int[] sumTopicWordCountLF;
    public double[] multiPros;
    public String folderPath;
    public String corpusPath;
    public String vectorFilePath;
    public double[][] wordVectors;
    public double[][] topicVectors;
    public int vectorSize;
    public double[][] dotProductValues;
    public double[][] expDotProductValues;
    public double[] sumExpValues;
    public final double l2Regularizer = 0.01;
    public final double tolerance = 0.05;
    public String expName = "LFLDA";
    public String orgExpName = "LFLDA";
    public String tAssignsFilePath = "";
    public int savestep = 0;

    public LFLDA(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords) throws Exception {
        this(pathToCorpus, pathToWordVectorsFile, inNumTopics, inAlpha, inBeta, inLambda, inNumInitIterations, inNumIterations, inTopWords, "LFLDA");
    }

    public LFLDA(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords, String inExpName) throws Exception {
        this(pathToCorpus, pathToWordVectorsFile, inNumTopics, inAlpha, inBeta, inLambda, inNumInitIterations, inNumIterations, inTopWords, inExpName, "", 0);
    }

    public LFLDA(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords, String inExpName, String pathToTAfile) throws Exception {
        this(pathToCorpus, pathToWordVectorsFile, inNumTopics, inAlpha, inBeta, inLambda, inNumInitIterations, inNumIterations, inTopWords, inExpName, pathToTAfile, 0);
    }

    public LFLDA(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords, String inExpName, int inSaveStep) throws Exception {
        this(pathToCorpus, pathToWordVectorsFile, inNumTopics, inAlpha, inBeta, inLambda, inNumInitIterations, inNumIterations, inTopWords, inExpName, "", inSaveStep);
    }

    public LFLDA(String pathToCorpus, String pathToWordVectorsFile, int inNumTopics, double inAlpha, double inBeta, double inLambda, int inNumInitIterations, int inNumIterations, int inTopWords, String inExpName, String pathToTAfile, int inSaveStep) throws Exception {
        this.alpha = inAlpha;
        this.beta = inBeta;
        this.lambda = inLambda;
        this.numTopics = inNumTopics;
        this.numIterations = inNumIterations;
        this.numInitIterations = inNumInitIterations;
        this.topWords = inTopWords;
        this.savestep = inSaveStep;
        this.orgExpName = this.expName = inExpName;
        this.vectorFilePath = pathToWordVectorsFile;
        this.corpusPath = pathToCorpus;
        this.folderPath = "results/";
        File dir = new File(this.folderPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        System.out.println("Reading topic modeling corpus: " + pathToCorpus);
        this.word2IdVocabulary = new HashMap();
        this.id2WordVocabulary = new HashMap();
        this.corpus = new ArrayList<List<Integer>>();
        this.numDocuments = 0;
        this.numWordsInCorpus = 0;
        BufferedReader br = null;
        try {
            String doc;
            int indexWord = -1;
            br = new BufferedReader(new FileReader(pathToCorpus));
            while ((doc = br.readLine()) != null) {
                if (doc.trim().length() == 0) continue;
                String[] words = doc.trim().split("\\s+");
                ArrayList<Integer> document = new ArrayList<Integer>();
                for (String word : words) {
                    if (this.word2IdVocabulary.containsKey(word)) {
                        document.add(this.word2IdVocabulary.get(word));
                        continue;
                    }
                    this.word2IdVocabulary.put(word, ++indexWord);
                    this.id2WordVocabulary.put(indexWord, word);
                    document.add(indexWord);
                }
                ++this.numDocuments;
                this.numWordsInCorpus += document.size();
                this.corpus.add(document);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.vocabularySize = this.word2IdVocabulary.size();
        this.docTopicCount = new int[this.numDocuments][this.numTopics];
        this.sumDocTopicCount = new int[this.numDocuments];
        this.topicWordCountLDA = new int[this.numTopics][this.vocabularySize];
        this.sumTopicWordCountLDA = new int[this.numTopics];
        this.topicWordCountLF = new int[this.numTopics][this.vocabularySize];
        this.sumTopicWordCountLF = new int[this.numTopics];
        this.multiPros = new double[this.numTopics * 2];
        for (int i = 0; i < this.numTopics * 2; ++i) {
            this.multiPros[i] = 1.0 / (double)this.numTopics;
        }
        this.alphaSum = (double)this.numTopics * this.alpha;
        this.betaSum = (double)this.vocabularySize * this.beta;
        this.readWordVectorsFile(this.vectorFilePath);
        this.topicVectors = new double[this.numTopics][this.vectorSize];
        this.dotProductValues = new double[this.numTopics][this.vocabularySize];
        this.expDotProductValues = new double[this.numTopics][this.vocabularySize];
        this.sumExpValues = new double[this.numTopics];
        System.out.println("Corpus size: " + this.numDocuments + " docs, " + this.numWordsInCorpus + " words");
        System.out.println("Vocabuary size: " + this.vocabularySize);
        System.out.println("Number of topics: " + this.numTopics);
        System.out.println("alpha: " + this.alpha);
        System.out.println("beta: " + this.beta);
        System.out.println("lambda: " + this.lambda);
        System.out.println("Number of initial sampling iterations: " + this.numInitIterations);
        System.out.println("Number of EM-style sampling iterations for the LF-LDA model: " + this.numIterations);
        System.out.println("Number of top topical words: " + this.topWords);
        this.tAssignsFilePath = pathToTAfile;
        if (this.tAssignsFilePath.length() > 0) {
            this.initialize(this.tAssignsFilePath);
        } else {
            this.initialize();
        }
    }

    public void readWordVectorsFile(String pathToWordVectorsFile) throws Exception {
        System.out.println("Reading word vectors from word-vectors file " + pathToWordVectorsFile + "...");
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(pathToWordVectorsFile));
            String[] elements = br.readLine().trim().split("\\s+");
            this.vectorSize = elements.length - 1;
            this.wordVectors = new double[this.vocabularySize][this.vectorSize];
            String word = elements[0];
            if (this.word2IdVocabulary.containsKey(word)) {
                for (int j = 0; j < this.vectorSize; ++j) {
                    this.wordVectors[this.word2IdVocabulary.get((Object)word).intValue()][j] = new Double(elements[j + 1]);
                }
            }
            while ((line = br.readLine()) != null) {
                elements = line.trim().split("\\s+");
                word = elements[0];
                if (!this.word2IdVocabulary.containsKey(word)) continue;
                for (int j = 0; j < this.vectorSize; ++j) {
                    this.wordVectors[this.word2IdVocabulary.get((Object)word).intValue()][j] = new Double(elements[j + 1]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.vocabularySize; ++i) {
            if (MatrixOps.absNorm(this.wordVectors[i]) != 0.0) continue;
            System.out.println("The word \"" + this.id2WordVocabulary.get(i) + "\" doesn't have a corresponding vector!!!");
        }
    }

    public void initialize() throws IOException {
        System.out.println("Randomly initialzing topic assignments ...");
        this.topicAssignments = new ArrayList<List<Integer>>();
        for (int docId = 0; docId < this.numDocuments; ++docId) {
            ArrayList<Integer> topics = new ArrayList<Integer>();
            int docSize = this.corpus.get(docId).size();
            for (int j = 0; j < docSize; ++j) {
                int wordId = this.corpus.get(docId).get(j);
                int subtopic = FuncUtils.nextDiscrete(this.multiPros);
                int topic = subtopic % this.numTopics;
                if (topic == subtopic) {
                    int[] nArray = this.topicWordCountLF[topic];
                    int n = wordId;
                    nArray[n] = nArray[n] + 1;
                    int n2 = topic;
                    this.sumTopicWordCountLF[n2] = this.sumTopicWordCountLF[n2] + 1;
                } else {
                    int[] nArray = this.topicWordCountLDA[topic];
                    int n = wordId;
                    nArray[n] = nArray[n] + 1;
                    int n3 = topic;
                    this.sumTopicWordCountLDA[n3] = this.sumTopicWordCountLDA[n3] + 1;
                }
                int[] nArray = this.docTopicCount[docId];
                int n = topic;
                nArray[n] = nArray[n] + 1;
                int n4 = docId;
                this.sumDocTopicCount[n4] = this.sumDocTopicCount[n4] + 1;
                topics.add(subtopic);
            }
            this.topicAssignments.add(topics);
        }
    }

    public void initialize(String pathToTopicAssignmentFile) {
        System.out.println("Reading topic-assignment file: " + pathToTopicAssignmentFile);
        this.topicAssignments = new ArrayList<List<Integer>>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(pathToTopicAssignmentFile));
            int docId = 0;
            int numWords = 0;
            while ((line = br.readLine()) != null) {
                String[] strTopics = line.trim().split("\\s+");
                ArrayList<Integer> topics = new ArrayList<Integer>();
                for (int j = 0; j < strTopics.length; ++j) {
                    int wordId = this.corpus.get(docId).get(j);
                    int subtopic = new Integer(strTopics[j]);
                    int topic = subtopic % this.numTopics;
                    if (topic == subtopic) {
                        int[] nArray = this.topicWordCountLF[topic];
                        int n = wordId;
                        nArray[n] = nArray[n] + 1;
                        int n2 = topic;
                        this.sumTopicWordCountLF[n2] = this.sumTopicWordCountLF[n2] + 1;
                    } else {
                        int[] nArray = this.topicWordCountLDA[topic];
                        int n = wordId;
                        nArray[n] = nArray[n] + 1;
                        int n3 = topic;
                        this.sumTopicWordCountLDA[n3] = this.sumTopicWordCountLDA[n3] + 1;
                    }
                    int[] nArray = this.docTopicCount[docId];
                    int n = topic;
                    nArray[n] = nArray[n] + 1;
                    int n4 = docId;
                    this.sumDocTopicCount[n4] = this.sumDocTopicCount[n4] + 1;
                    topics.add(subtopic);
                    ++numWords;
                }
                this.topicAssignments.add(topics);
                ++docId;
            }
            if (docId != this.numDocuments || numWords != this.numWordsInCorpus) {
                System.out.println("The topic modeling corpus and topic assignment file are not consistent!!!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void inference() throws IOException {
        int iter;
        System.out.println("Running Gibbs sampling inference: ");
        for (iter = 1; iter <= this.numInitIterations; ++iter) {
            System.out.println("\tInitial sampling iteration: " + iter);
            this.sampleSingleInitialIteration();
        }
        for (iter = 1; iter <= this.numIterations; ++iter) {
            System.out.println("\tLFLDA sampling iteration: " + iter);
            this.optimizeTopicVectors();
            this.sampleSingleIteration();
            if (this.savestep <= 0 || iter % this.savestep != 0 || iter >= this.numIterations) continue;
            System.out.println("\t\tSaving the output from the " + iter + "^{th} sample");
            this.expName = this.orgExpName + "-" + iter;
            this.write();
        }
        this.expName = this.orgExpName;
        this.writeParameters();
        System.out.println("Writing output from the last sample ...");
        this.write();
        System.out.println("Sampling completed!");
    }

    public void optimizeTopicVectors() {
        System.out.println("\t\tEstimating topic vectors ...");
        this.sumExpValues = new double[this.numTopics];
        this.dotProductValues = new double[this.numTopics][this.vocabularySize];
        this.expDotProductValues = new double[this.numTopics][this.vocabularySize];
        Parallel.loop(this.numTopics, new Parallel.LoopInt(){

            @Override
            public void compute(int topic) {
                int rate = 1;
                boolean check = true;
                while (check) {
                    double l2Value = 0.01 * (double)rate;
                    try {
                        TopicVectorOptimizer optimizer = new TopicVectorOptimizer(LFLDA.this.topicVectors[topic], LFLDA.this.topicWordCountLF[topic], LFLDA.this.wordVectors, l2Value);
                        LBFGS gd = new LBFGS(optimizer, 0.05);
                        gd.optimize(600);
                        optimizer.getParameters(LFLDA.this.topicVectors[topic]);
                        LFLDA.this.sumExpValues[topic] = optimizer.computePartitionFunction(LFLDA.this.dotProductValues[topic], LFLDA.this.expDotProductValues[topic]);
                        check = false;
                        if (LFLDA.this.sumExpValues[topic] == 0.0 || Double.isInfinite(LFLDA.this.sumExpValues[topic])) {
                            int index;
                            double max = -1.0E9;
                            for (index = 0; index < LFLDA.this.vocabularySize; ++index) {
                                if (!(LFLDA.this.dotProductValues[topic][index] > max)) continue;
                                max = LFLDA.this.dotProductValues[topic][index];
                            }
                            for (index = 0; index < LFLDA.this.vocabularySize; ++index) {
                                LFLDA.this.expDotProductValues[topic][index] = Math.exp(LFLDA.this.dotProductValues[topic][index] - max);
                                int n = topic;
                                LFLDA.this.sumExpValues[n] = LFLDA.this.sumExpValues[n] + LFLDA.this.expDotProductValues[topic][index];
                            }
                        }
                    }
                    catch (InvalidOptimizableException e) {
                        e.printStackTrace();
                        check = true;
                    }
                    rate *= 10;
                }
            }
        });
    }

    public void sampleSingleIteration() {
        for (int dIndex = 0; dIndex < this.numDocuments; ++dIndex) {
            int docSize = this.corpus.get(dIndex).size();
            for (int wIndex = 0; wIndex < docSize; ++wIndex) {
                int word = this.corpus.get(dIndex).get(wIndex);
                int subtopic = this.topicAssignments.get(dIndex).get(wIndex);
                int topic = subtopic % this.numTopics;
                int[] nArray = this.docTopicCount[dIndex];
                int n = topic;
                nArray[n] = nArray[n] - 1;
                if (subtopic == topic) {
                    int[] nArray2 = this.topicWordCountLF[topic];
                    int n2 = word;
                    nArray2[n2] = nArray2[n2] - 1;
                    int n3 = topic;
                    this.sumTopicWordCountLF[n3] = this.sumTopicWordCountLF[n3] - 1;
                } else {
                    int[] nArray3 = this.topicWordCountLDA[topic];
                    int n4 = word;
                    nArray3[n4] = nArray3[n4] - 1;
                    int n5 = topic;
                    this.sumTopicWordCountLDA[n5] = this.sumTopicWordCountLDA[n5] - 1;
                }
                for (int tIndex = 0; tIndex < this.numTopics; ++tIndex) {
                    this.multiPros[tIndex] = ((double)this.docTopicCount[dIndex][tIndex] + this.alpha) * this.lambda * this.expDotProductValues[tIndex][word] / this.sumExpValues[tIndex];
                    this.multiPros[tIndex + this.numTopics] = ((double)this.docTopicCount[dIndex][tIndex] + this.alpha) * (1.0 - this.lambda) * ((double)this.topicWordCountLDA[tIndex][word] + this.beta) / ((double)this.sumTopicWordCountLDA[tIndex] + this.betaSum);
                }
                subtopic = FuncUtils.nextDiscrete(this.multiPros);
                topic = subtopic % this.numTopics;
                int[] nArray4 = this.docTopicCount[dIndex];
                int n6 = topic;
                nArray4[n6] = nArray4[n6] + 1;
                if (subtopic == topic) {
                    int[] nArray5 = this.topicWordCountLF[topic];
                    int n7 = word;
                    nArray5[n7] = nArray5[n7] + 1;
                    int n8 = topic;
                    this.sumTopicWordCountLF[n8] = this.sumTopicWordCountLF[n8] + 1;
                } else {
                    int[] nArray6 = this.topicWordCountLDA[topic];
                    int n9 = word;
                    nArray6[n9] = nArray6[n9] + 1;
                    int n10 = topic;
                    this.sumTopicWordCountLDA[n10] = this.sumTopicWordCountLDA[n10] + 1;
                }
                this.topicAssignments.get(dIndex).set(wIndex, subtopic);
            }
        }
    }

    public void sampleSingleInitialIteration() {
        for (int dIndex = 0; dIndex < this.numDocuments; ++dIndex) {
            int docSize = this.corpus.get(dIndex).size();
            for (int wIndex = 0; wIndex < docSize; ++wIndex) {
                int word = this.corpus.get(dIndex).get(wIndex);
                int subtopic = this.topicAssignments.get(dIndex).get(wIndex);
                int topic = subtopic % this.numTopics;
                int[] nArray = this.docTopicCount[dIndex];
                int n = topic;
                nArray[n] = nArray[n] - 1;
                if (subtopic == topic) {
                    int[] nArray2 = this.topicWordCountLF[topic];
                    int n2 = word;
                    nArray2[n2] = nArray2[n2] - 1;
                    int n3 = topic;
                    this.sumTopicWordCountLF[n3] = this.sumTopicWordCountLF[n3] - 1;
                } else {
                    int[] nArray3 = this.topicWordCountLDA[topic];
                    int n4 = word;
                    nArray3[n4] = nArray3[n4] - 1;
                    int n5 = topic;
                    this.sumTopicWordCountLDA[n5] = this.sumTopicWordCountLDA[n5] - 1;
                }
                for (int tIndex = 0; tIndex < this.numTopics; ++tIndex) {
                    this.multiPros[tIndex] = ((double)this.docTopicCount[dIndex][tIndex] + this.alpha) * this.lambda * ((double)this.topicWordCountLF[tIndex][word] + this.beta) / ((double)this.sumTopicWordCountLF[tIndex] + this.betaSum);
                    this.multiPros[tIndex + this.numTopics] = ((double)this.docTopicCount[dIndex][tIndex] + this.alpha) * (1.0 - this.lambda) * ((double)this.topicWordCountLDA[tIndex][word] + this.beta) / ((double)this.sumTopicWordCountLDA[tIndex] + this.betaSum);
                }
                subtopic = FuncUtils.nextDiscrete(this.multiPros);
                topic = subtopic % this.numTopics;
                int[] nArray4 = this.docTopicCount[dIndex];
                int n6 = topic;
                nArray4[n6] = nArray4[n6] + 1;
                if (topic == subtopic) {
                    int[] nArray5 = this.topicWordCountLF[topic];
                    int n7 = word;
                    nArray5[n7] = nArray5[n7] + 1;
                    int n8 = topic;
                    this.sumTopicWordCountLF[n8] = this.sumTopicWordCountLF[n8] + 1;
                } else {
                    int[] nArray6 = this.topicWordCountLDA[topic];
                    int n9 = word;
                    nArray6[n9] = nArray6[n9] + 1;
                    int n10 = topic;
                    this.sumTopicWordCountLDA[n10] = this.sumTopicWordCountLDA[n10] + 1;
                }
                this.topicAssignments.get(dIndex).set(wIndex, subtopic);
            }
        }
    }

    public void writeParameters() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".paras"));
        writer.write("-model\tLFLDA");
        writer.write("\n-corpus\t" + this.corpusPath);
        writer.write("\n-vectors\t" + this.vectorFilePath);
        writer.write("\n-ntopics\t" + this.numTopics);
        writer.write("\n-alpha\t" + this.alpha);
        writer.write("\n-beta\t" + this.beta);
        writer.write("\n-lambda\t" + this.lambda);
        writer.write("\n-initers\t" + this.numInitIterations);
        writer.write("\n-niters\t" + this.numIterations);
        writer.write("\n-twords\t" + this.topWords);
        writer.write("\n-name\t" + this.expName);
        if (this.tAssignsFilePath.length() > 0) {
            writer.write("\n-initFile\t" + this.tAssignsFilePath);
        }
        if (this.savestep > 0) {
            writer.write("\n-sstep\t" + this.savestep);
        }
        writer.close();
    }

    public void writeDictionary() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".vocabulary"));
        for (String word : this.word2IdVocabulary.keySet()) {
            writer.write(word + " " + this.word2IdVocabulary.get(word) + "\n");
        }
        writer.close();
    }

    public void writeIDbasedCorpus() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".IDcorpus"));
        for (int dIndex = 0; dIndex < this.numDocuments; ++dIndex) {
            int docSize = this.corpus.get(dIndex).size();
            for (int wIndex = 0; wIndex < docSize; ++wIndex) {
                writer.write(this.corpus.get(dIndex).get(wIndex) + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeTopicAssignments() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".topicAssignments"));
        for (int dIndex = 0; dIndex < this.numDocuments; ++dIndex) {
            int docSize = this.corpus.get(dIndex).size();
            for (int wIndex = 0; wIndex < docSize; ++wIndex) {
                writer.write(this.topicAssignments.get(dIndex).get(wIndex) + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeTopicVectors() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".topicVectors"));
        for (int i = 0; i < this.numTopics; ++i) {
            for (int j = 0; j < this.vectorSize; ++j) {
                writer.write(this.topicVectors[i][j] + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeTopTopicalWords() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".topWords"));
        block0: for (int tIndex = 0; tIndex < this.numTopics; ++tIndex) {
            Map<Integer, Double> topicWordProbs = new TreeMap();
            for (int wIndex = 0; wIndex < this.vocabularySize; ++wIndex) {
                double pro = this.lambda * this.expDotProductValues[tIndex][wIndex] / this.sumExpValues[tIndex] + (1.0 - this.lambda) * ((double)this.topicWordCountLDA[tIndex][wIndex] + this.beta) / ((double)this.sumTopicWordCountLDA[tIndex] + this.betaSum);
                topicWordProbs.put(wIndex, pro);
            }
            topicWordProbs = FuncUtils.sortByValueDescending(topicWordProbs);
            Set mostLikelyWords = topicWordProbs.keySet();
            int count = 0;
            for (Integer index : mostLikelyWords) {
                if (count < this.topWords) {
                    writer.write(this.id2WordVocabulary.get(index) + " ");
                    ++count;
                    continue;
                }
                writer.write("\n");
                continue block0;
            }
        }
        writer.close();
    }

    public void writeTopicWordPros() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".phi"));
        for (int t = 0; t < this.numTopics; ++t) {
            for (int w = 0; w < this.vocabularySize; ++w) {
                double pro = this.lambda * this.expDotProductValues[t][w] / this.sumExpValues[t] + (1.0 - this.lambda) * ((double)this.topicWordCountLDA[t][w] + this.beta) / ((double)this.sumTopicWordCountLDA[t] + this.betaSum);
                writer.write(pro + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void writeDocTopicPros() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + this.expName + ".theta"));
        for (int i = 0; i < this.numDocuments; ++i) {
            for (int j = 0; j < this.numTopics; ++j) {
                double pro = ((double)this.docTopicCount[i][j] + this.alpha) / ((double)this.sumDocTopicCount[i] + this.alphaSum);
                writer.write(pro + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void write() throws IOException {
        this.writeTopTopicalWords();
        this.writeDocTopicPros();
        this.writeTopicAssignments();
        this.writeTopicWordPros();
    }

    public static void main(String[] args) throws Exception {
        LFLDA lflda = new LFLDA("test/corpus.txt", "test/wordVectors.txt", 4, 0.1, 0.01, 0.6, 2000, 200, 20, "testLFLDA");
        lflda.writeParameters();
        lflda.inference();
    }
}

