/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.DenseAssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Randoms;
import java.util.Collection;

public abstract class AbstractFactor
implements Factor {
    protected VarSet vars;

    protected AbstractFactor() {
        this.vars = new HashVarSet();
    }

    protected AbstractFactor(VarSet vars) {
        this.vars = vars;
    }

    protected abstract Factor extractMaxInternal(VarSet var1);

    protected abstract double lookupValueInternal(int var1);

    protected abstract Factor marginalizeInternal(VarSet var1);

    @Override
    public double value(Assignment assn) {
        return this.lookupValueInternal(assn.singleIndex());
    }

    @Override
    public double value(AssignmentIterator it) {
        return this.lookupValueInternal(it.indexOfCurrentAssn());
    }

    public double phi(DenseAssignmentIterator it) {
        return this.lookupValueInternal(it.indexOfCurrentAssn());
    }

    @Override
    public Factor marginalize(Variable[] vars) {
        return this.marginalizeInternal(new HashVarSet(vars));
    }

    @Override
    public Factor marginalize(Collection vars) {
        return this.marginalizeInternal(new HashVarSet(vars));
    }

    @Override
    public Factor marginalize(Variable var) {
        return this.marginalizeInternal(new HashVarSet(new Variable[]{var}));
    }

    @Override
    public Factor marginalizeOut(Variable var) {
        HashVarSet vars = new HashVarSet(this.vars);
        vars.remove(var);
        return this.marginalizeInternal(vars);
    }

    @Override
    public Factor marginalizeOut(VarSet varset) {
        HashVarSet vars = new HashVarSet(this.vars);
        vars.remove(varset);
        return this.marginalizeInternal(vars);
    }

    @Override
    public Factor extractMax(Variable[] vars) {
        return this.extractMaxInternal(new HashVarSet(vars));
    }

    @Override
    public Factor extractMax(Collection vars) {
        return this.extractMaxInternal(new HashVarSet(vars));
    }

    @Override
    public Factor extractMax(Variable var) {
        return this.extractMaxInternal(new HashVarSet(new Variable[]{var}));
    }

    @Override
    public int argmax() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public Assignment sample(Randoms r) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public double sum() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public Factor multiply(Factor dist) {
        Factor dup = this.duplicate();
        dup.multiplyBy(dist);
        return dup;
    }

    @Override
    public void multiplyBy(Factor pot) {
        throw new UnsupportedOperationException("Cannot multiply " + this + " by " + pot);
    }

    @Override
    public void exponentiate(double power) {
        throw new UnsupportedOperationException("Cannot exponentiate " + this + " by " + power);
    }

    @Override
    public void divideBy(Factor pot) {
        throw new UnsupportedOperationException("Cannot divide " + this + " by " + pot);
    }

    public boolean isInLogSpace() {
        return false;
    }

    public void logify() {
        throw new UnsupportedOperationException(this.toString());
    }

    public void delogify() {
        throw new UnsupportedOperationException(this.toString());
    }

    public Factor log() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public boolean containsVar(Variable var) {
        return this.vars.contains(var);
    }

    @Override
    public VarSet varSet() {
        return this.vars;
    }

    @Override
    public AssignmentIterator assignmentIterator() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public boolean almostEquals(Factor p) {
        return this.almostEquals(p, 1.0E-5);
    }

    @Override
    public double logValue(Assignment assn) {
        return Math.log(this.value(assn));
    }

    @Override
    public double logValue(AssignmentIterator it) {
        return Math.log(this.value(it));
    }

    @Override
    public double logValue(int loc) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public Variable getVariable(int i) {
        return this.vars.get(i);
    }

    @Override
    public AbstractTableFactor asTable() {
        throw new UnsupportedOperationException(this.toString());
    }

    protected void setVarSet(VarSet vars) {
        this.vars = vars;
    }

    @Override
    public String prettyOutputString() {
        StringBuffer buf = new StringBuffer();
        for (Variable var : this.vars) {
            buf.append(var.getLabel());
            buf.append(" ");
        }
        buf.append("~ Factor\n");
        return buf.toString();
    }
}

