
This is the version of the code that was used to produce the results presented in our paper "Community detection in sparse time-evolving graphs with a dynamical Bethe-Hessian" submitted to NeurIPS 2020. 


# Package installation (with Anaconda)

To run our notebooks, open the terminal and type
```bash
conda env create -f neurips20.yml
conda activate neurips20
jupyter notebook
```

# Content

## Notebooks

In general, the notebooks have parameters to run in a reasonable amount of time which is reported inside the notebooks themselves if not otherwise specified. To obtain the more time consuming results of the paper the parameters have to be set as how specified in the article. Each notebook's title indicates the result reproduced by the notebook: for example Appendix C reproduces all the Figures of Appendix C. The codes used to produce Figure 9  can also be used to obtain the right plot of Figure 3.  Note that the code to reproduce the BP overlap was provided by Amir Ghasemian and is not publicly available.

## Demo 

In this notebook we explain how to use the basic functions to create the graph series $\{\mathcal{G}_t\}_{t=1,\dots,T}$ and how to use our implementation of Algorithm 1 and Algorithm 2 described in the article. We further provide a more visual representation of the problem representing the adjacency matrix at different time-steps and the community evolution with an alluvial graph.  

## Datasets

This folder contains to file used in the Figure_4 notebook, containing the dataset information of the Primary school network of the SocioPatterns project.


## Package

Here there are the files containing the implementation of the main functions. These are:
* *dynamic_SC_BH* : implementation of Algorithm 1 and Algorithm 2
* *dynamic_SC* : implementation of the competing dynamic spectral algorithms for which we provide comparison in the article.
* *static_SC* : implementation of the static Bethe-Hessian
* *functions_for_DDCSBM* : generic functions used by the main algorithm or to produce the graph sequence $\{\mathcal{G}_t\}_{t = 1,\dots,T}$.

Note that the static_SC.py is third-party software and was downloaded from here: http://lorenzodallamico.github.io/codes/SC_sparse_2020.zip (associated papers: https://papers.nips.cc/paper/8658-revisiting-the-bethe-hessian-improved-community-detection-in-sparse-heterogeneous-graphs.pdf, https://arxiv.org/pdf/2003.09198.pdf)


