import torch
import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import imageio

def plot_gif(before_project, after_project, arrow, name = '0'):
    def generate_one_frame(data, pred, arrow, xy_max = 2):

        fig, ax = plt.subplots(figsize=(10,10))

        X, Y, U, V = zip(*[arrow])
        ax.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

        ax.scatter(data[:,0], data[:,1], c = 'y')
        ax.scatter(pred[:,0], pred[:,1], c = 'b')       
        ax.grid()
        ax.set(xlabel='X', ylabel='Y', title='yellow: points before projection; blue: after projection.')
        ax.set_xlim(-xy_max, xy_max)
        ax.set_ylim(-xy_max, xy_max)
        fig.canvas.draw()     
        # fig.show()

        image = np.frombuffer(fig.canvas.tostring_rgb(), dtype='uint8')
        image  = image.reshape(fig.canvas.get_width_height()[::-1] + (3,))


        return image
    
    imageio.mimsave('./visualization_' + name + '.gif', [
        generate_one_frame(before_project[i], after_project[i], arrow[i]) 
        for i in range(len(before_project))
        ], fps=10)

def show_one_frame(data, pred, arrow, xy_max = 1):
    X, Y, U, V = zip(*[arrow])
    plt.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

    plt.scatter(data[:,0], data[:,1], c = 'y')
    plt.scatter(pred[:,0], pred[:,1], c = 'b')       
    plt.grid()
    plt.title('yellow: points before projection; blue: after projection.')
    plt.xlim(-xy_max, xy_max)
    plt.ylim(-xy_max, xy_max)
    plt.show()


class Proj():
    def __init__(self):
        model_path = 'models/checkpoint _1000.pt'
        self.model = torch.load(model_path).cpu()
        # print(self.model.iter)
        # self.model.iter = 1
        # print(self.model.iter)
    def project(self, data):
        d = torch.Tensor(data[None, :, :])
        pred = self.model(d)
        pred = pred[0,:,:]
        return pred.detach().numpy()

def test(te = 0):
    data = np.zeros([8,2])
    dx = 0.1
    timestamp = 0.1

    for i in range(data.shape[0]):
        data[i, 0] = i * dx
        data[i, 1] = 0

    if te == 0:
        # force = lambda t: np.array([np.sin(t*2), np.cos(t*2)]) * 10
        force0 = np.array([-5, 10]) 
        force3 = np.array([0, -20]) 
        force7 = np.array([5, 10])         
        g = np.array([0, 0])
    
    if te == 1:
        force0 = np.array([0, 5]) 
        force3 = np.array([0, -10]) 
        force7 = np.array([0, 5])         
        g = np.array([0, 0])

    if te == 2:
        force0 = np.array([0, 20]) 
        force3 = np.array([0, 0]) 
        force7 = np.array([0, 20])         
        g = np.array([0, -5])
    


    vel = np.array(data)*0
    data_list = []
    proj_list = []
    force_list = []
    pr = Proj()
    for ite in range(100):
        new_data = np.array(data)
        vel[7, :] += force7 * timestamp
        vel[3, :] += force3 * timestamp
        vel[0, :] += force0 * timestamp
        for i in range (0, len(data)):
            vel[i, :] += timestamp * g
            new_data[i, :] = data[i,:] + vel[i,:] * timestamp 

        data_list.append(np.array(new_data))
        force_list.append(np.array([
            [new_data[7,0], new_data[3,0], new_data[0,0]],
            [new_data[7,1], new_data[3,1], new_data[0,1]],
            [force7[0]/20, force3[0]/20, force0[0]/20 ], 
            [force7[1]/20, force3[1]/20, force0[1]/20 ]
            ]))

        new_data = pr.project(new_data) # new_data*0.5 + 0.5 * 
        new_data = pr.project(new_data) # new_data*0.5 + 0.5 * 
        

        proj_list.append(np.array(new_data))
        
        for i in range (len(data)):
           vel[i,:] =  (new_data[i,:] - data[i,:]) / timestamp # vel[i,:] * 0.5 + 0.5 *
        # print(new_data); print(data); print(vel)
        # show_one_frame(data_list[-1], proj_list[-1], force_list[-1])

        data = (np.array(new_data))
        # aaaaaaaaaaaaaaaaaaaa

    plot_gif(data_list, proj_list, force_list, 'rope_8_free_bend_2proj_' + str(te))




if __name__ == '__main__':
    test(0)
    test(1)
    test(2)