% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observations.R
\name{prepare_data}
\alias{prepare_data}
\alias{prepare_data.empirical}
\alias{prepare_data.causal}
\alias{prepare_data.gaussian}
\alias{prepare_data.copula}
\title{Generate data used for predictions}
\usage{
prepare_data(x, ...)

\method{prepare_data}{empirical}(x, seed = 1, n_samples = 1000, index_features = NULL, ...)

\method{prepare_data}{causal}(
  x,
  seed = NULL,
  n_samples = 1000,
  index_features = NULL,
  asymmetric = FALSE,
  ordering = NULL,
  ...
)

\method{prepare_data}{gaussian}(
  x,
  seed = 1,
  n_samples = 1000,
  index_features = NULL,
  asymmetric = FALSE,
  ordering = NULL,
  ...
)

\method{prepare_data}{copula}(
  x,
  x_test_gaussian = 1,
  seed = 1,
  n_samples = 1000,
  index_features = NULL,
  ...
)
}
\arguments{
\item{x}{Explainer object. See \code{\link{explain}} for more information.}

\item{...}{Currently not used.}

\item{seed}{Positive integer. If \code{NULL} the seed will be inherited from the calling environment.}

\item{n_samples}{Positive integer. Indicating the maximum number of samples to use in the
Monte Carlo integration for every conditional expectation.}

\item{index_features}{Positive integer vector. Specifies the indices of combinations to apply to the present method.
\code{NULL} means all combinations. Only used internally.}

\item{asymmetric}{Logical flag that specifies whether we only consider variable permutations
consistent with the given ordering.}

\item{ordering}{List of vectors specifying (partial) causal ordering. Each element in
the list is a component in the order, which can contain one or more variable indices in a vector.
For example, in list(1, c(2, 3)), 2 > 1 and 3 > 1, but 2 and 3 are not comparable.}

\item{x_test_gaussian}{Matrix. Test data quantile-transformed to standard Gaussian variables. Only applicable if
\code{approach = "empirical"}.}
}
\description{
Generate data used for predictions
}
