# Output Diversified Sampling (ODS) with the Boundary Attack

## Running experiments

The implemented method corresponds to Boundary-ODS in Section 5.2 of the paper.

The following experiments correspond results by Boundary-ODS and Boundary Attack in Table 5 and Figure 3 of the paper (the experiments are held with 10 images which we used in the paper).

___

### Requirement

Since the implementation is based on [foolbox](https://github.com/bethgelab/foolbox), the requirement is also based on foolbox.

1. install python >= 3.6
1. install PyTorch >= 1.4.0
1. install pickle
1. install foolbox
```bash
  $ pip install foolbox 
```

___

### Evaluation Boundary Attack with Output Diversified Sampling (ODS):
The following evaluation is held for 10 images on ImageNet (images are already resized and cropped).

#### Evaluate Boundary Attack with ODS (Boundary-ODS in Table 5):

* untargeted settings:
```bash
  $ python boundaryODS.py --data_folder ../data_NeurIPS --num_sample 10 --ODS 
```

* targeted settings:
```bash
  $ python boundaryODS.py --data_folder ../data_NeurIPS --num_sample 10  --ODS --targeted
```

#### Evaluate Boundary attack with random sampling (Boundary in Table 5):

* untargeted settings:
```bash
  $ python boundaryODS.py --data_folder ../data_NeurIPS --num_sample 10 
```

* targeted settings:
```bash
  $ python boundaryODS.py --data_folder ../data_NeurIPS --num_sample 10 --targeted
```

## Acknowledgement
Our codes are based on [foolbox](https://github.com/bethgelab/foolbox).

