# Output Diversified Sampling for Initialization (ODI)

## Running experiments

The following experiment corresponds to ODI with PGD attack on CIFAR-10 in Section 4 of the paper.

### Requirements

Experiments in the paper were performed under tensorflow 1.14.0.

### Evaluation PGD attack with ODI (in Table 1 of Section 4.1 in the paper):

* Download pre-trained model (trained by [MadryLab](https://github.com/MadryLab/cifar10_challenge))
```bash
  $ python fetch_model.py secret
```

* Evaluate PGD attack with ODI (ODI-PGD):
```bash
  $ python eval_ODI_PGD.py --num_restart 20 --num_step_ODI 2 --data_path [PATH_TO_CIFAR10]
```

* Evaluate PGD attack with naive random initialization (sampled from a uniform distribution):
```bash
  $ python eval_ODI_PGD.py --num_restart 20 --num_step_ODI 0 --data_path [PATH_TO_CIFAR10]
```

### Evaluation tuned PGD attack with ODI (in Table 2 of Section 4.2 in the paper):

* Download pre-trained model (trained by [MadryLab](https://github.com/MadryLab/cifar10_challenge))
```bash
  $ python fetch_model.py secret
```

* Evaluate PGD attack with ODI (ODI-PGD):
```bash
  $ python eval_ODI_tuned_PGD.py --data_path [PATH_TO_CIFAR10]
```

## Acknowledgement
Our codes for PGD are based on [CIFAR10 Adversarial Examples Challenge](https://github.com/MadryLab/cifar10_challenge). 

