#!/bin/bash

mkdir -p log

stage=4
ngpu=1
other_otps=

blayers=3; bunits=512; bprojs=512; elayers=3; eunits=1024; eprojs=1024; batchsize=8; maxlen_in=500; preprocess_conf="conf/preprocess.conf"; other_opts="--stats-file fbank/tr_spatialized_all/cmvn.ark"

#train_config=conf/train_multispkr_transformer_freeze_frontend_several_epochs.yaml 
#train_config=conf/train_multispkr_transformer_freeze_frontend.yaml
train_config=conf/train_multispkr_transformer.yaml
#train_config=conf/train_multispkr_transformer_freeze_frontend_asr_init.yaml

log=log/log.stage${stage}

qsub -cwd -o ${log} -j y run.sh \
    --backend pytorch \
    --stage ${stage} \
    --ngpu ${ngpu} \
    --dumpdir data \
    --blayers ${blayers} \
    --bunits ${bunits} \
    --bprojs ${bprojs} \
    --preprocess-config ${preprocess_conf} \
    --train-config ${train_config} \
    ${other_opts}
