GetMeanEstimate <- function(experimentData){
  estimate <- experimentData %>% group_by(producerInTreatment) %>%
    summarise(beforeAdjustment = mean(withNoise),
              beforeAdjustmentVar = var(withNoise) / n(),
              observedSecondOrderEffectMean = mean(secondOrderEffectWithNoise),
              observedSecondOrderEffectSd = sd(secondOrderEffectWithNoise),
              V1 = mean(feedbackWithNoiseSum, na.rm = TRUE),
              V2 = mean(feedbackWithNoiseSquaredSum[pureTreatmentDegree > 1], na.rm = TRUE),
              V3 = mean((feedbackWithNoiseSum[pureTreatmentDegree > 1])^2, na.rm = TRUE),
              degreeRatioMean = mean(pureTreatmentDegree / degree, na.rm = TRUE),
              secondOrderdegreeRatioMean = mean(pureTreatmentDegree[pureTreatmentDegree > 1] * (pureTreatmentDegree[pureTreatmentDegree > 1] - 1)  /
                                                  (degree[pureTreatmentDegree > 1] * (degree[pureTreatmentDegree > 1] - 1)), na.rm = TRUE),
              expectedSecondOrderEffectMean = V1 / degreeRatioMean,
              expectedSecondOrderEffectSd = sqrt(V2 / degreeRatioMean + 
                                                   (V3 - V2) / secondOrderdegreeRatioMean - (expectedSecondOrderEffectMean)^2),
              afterAdjustment = weighted.mean(withNoise, 
                                                  w = exp(dnorm(secondOrderEffectWithNoise, 
                                                            mean = expectedSecondOrderEffectMean, sd = observedSecondOrderEffectSd, log = TRUE) - 
                                                    dnorm(secondOrderEffectWithNoise,
                                                          mean = observedSecondOrderEffectMean, sd = observedSecondOrderEffectSd, log = TRUE)), na.rm = TRUE)) %>% 
    ungroup() %>% select(producerInTreatment, beforeAdjustment, beforeAdjustmentVar, afterAdjustment, 
                         observedSecondOrderEffectMean, observedSecondOrderEffectSd, expectedSecondOrderEffectMean, expectedSecondOrderEffectSd)
  return(estimate)
}

# function for estimating average response and the variance of the estimator
GetEstimate <- function(experimentId, GetExperimentDataPath, producerDegree, beta, delta, nBootIter = 100, nCores = 1){
  cat(paste0("Computing estimates for delta = ", delta, ", beta = ", beta, " and experimentId = ", experimentId, "\n"))
  load(GetExperimentDataPath(experimentId, delta, beta))
  experimentData <- experimentData %>% filter(!is.na(producerInTreatment)) %>% left_join(producerDegree, by = "producer")
  estimate <- GetMeanEstimate(experimentData)
  bootstrapEstimates <- mclapply(1:nBootIter, 
                                 function (i) GetMeanEstimate(experimentData[sample(nrow(experimentData), 
                                                                                    replace = TRUE), ]), mc.cores = nCores)
  bootstrapEstimates <- do.call("rbind", bootstrapEstimates)
  bootstrapVar <- bootstrapEstimates %>% group_by(producerInTreatment) %>% 
    summarise(beforeAdjustmentBootVar = var(beforeAdjustment), afterAdjustmentBootVar = var(afterAdjustment))
  estimate <- estimate %>% left_join(bootstrapVar, "producerInTreatment")
  estimate$experimentId <- experimentId
  estimate$delta <- delta
  estimate$beta <- beta
  return(estimate)
}