%%
% Fig 13(a) in Sec C.3.2
% Test the expression for Lyap Exp in Thm 9 for non-periodic function given
% in Example 2
% This script plots the dependence of Lyap exp on eta
% f_0=x^4/4
% f_1=eps*sin(x/eps)+eps*sin(sqrt(2)x/eps)
%%
epsilon=0.00001;    % fixed epsilon
MAX=1000;           % number of steps for iteration then estimating Lyap exp
grad=@(x)cos(x./epsilon)+sqrt(2)*cos(sqrt(2)*x./epsilon);   % gradient of f_0+f_1
d_grad=@(x)-sin(x./epsilon)./epsilon-2*sin(sqrt(2)*x./epsilon)./epsilon;% 2-order gradient of f_0+f_1 
eta=0.0002:0.0001:0.1;   % range of eta to be tested
L_memory=eta;
x=rand(1,length(eta));  % ramdom initial values
d_memory=zeros(1,length(eta));
%%
for j=1:MAX
    x=x-eta.*grad(x);
    d_memory=d_memory+log(abs(1-eta.*d_grad(x)));   % calsulte the sum of ln(phi'')
end
%% evolving
figure
plot(eta,d_memory/MAX);
xlabel('\eta')
ylabel('Lyap Exp \lambda(x)')
set(gca,'FontSize',24);
set(gcf,'Position',[400 300 800 600]);

figure
plot(eta,d_memory/MAX-log(eta/epsilon));
title(["\fontsize{32}Lyap Exp against \eta (\epsilon=1e-5)"])
xlabel('\eta')
ylabel('\lambda(x)-ln(\eta/\epsilon)')
set(gca,'FontSize',24);
set(gcf,'Position',[400 300 800 600]);