%%
% Fig 9 in Sec C.2
% Test the explixit expression of invariant distribution in 2-dim with
% Matyas function.
% The surface is theoretical value given in Prop 6
% The axis are rescaled by sqrt(eta)


%%
% Note that if eta is small, 
% MAX (number of iteration) needs to increase as well
global epsilon
eta=0.01;
N=50000;            % number of initial points
MAX=10000;          % number of steps for evolving the ensemble
epsilon=0.00001;    % if eta is smaller, eps needs to be adjust to satisfy eps<<eta

f_0=@(x)0.26*(x(1,:).^2+x(2,:).^2)+0.48*x(2,:).*x(1,:); % Matyas function
f_1=@(x)epsilon*(sin(x(1,:)/epsilon)+cos(x(2,:)/epsilon));  % periodic f_1

x_0=randn(2,N)*0.01;    % randomly sampled initial ensemble
x=x_0;
for i=1:MAX
    x=x-eta*(grad_0(x)+grad_1(x));  %evolving
end

%% plot the result
figure
w_x=(-6:0.1:6);
w_y=(-6:0.1:6);
[X,Y]=meshgrid(w_x,w_y);
temp=size(X);
W=zeros(2,temp(1),temp(2));
W(1,:,:)=X;
W(2,:,:)=Y;
H=[0.52,0.48;0.48,0.52];        % covariace matrix of normal distribution
fun=@(x,y)exp(-2*(x.*x*H(1,1)+x.*y*H(1,2)+y.*x*H(2,1)+y.*y*H(2,2)));    % theoretical density before normalization
int=integral2(fun,-Inf,Inf,-Inf,Inf);

% plot after rescaling the axis by sqrt(eta), which makes theoretical
% distribution is independent from eta after rescaling.
histogram2(x(1,:)/sqrt(eta),x(2,:)/sqrt(eta),'XBinEdges',[-6:0.1:6],'YBinEdges',[-6:0.1:6],'Normalization','pdf');
hold on
% theoretical pdf after rescaling
s=mesh(X,Y,exp(-2*(X.*X*H(1,1)+X.*Y*H(1,2)+Y.*X*H(2,1)+Y.*Y*H(2,2)))/int); 
s.FaceAlpha=0.5;
hold off

zlim([0,0.17])
xlabel('x/\eta^{0.5}')
ylabel('y/\eta^{0.5}')
zlabel('density')

%%

% gradient of f_0
function g=grad_0(x)
g=zeros(size(x));
g(1,:)=0.52*x(1,:)+0.48*x(2,:);
g(2,:)=0.52*x(2,:)+0.48*x(1,:);
end

% gradient of f_1,eps
function g=grad_1(x)
global epsilon
g=zeros(size(x));
g(1,:)=cos(x(1,:)/epsilon);
g(2,:)=-sin(x(2,:)/epsilon);
end
