
import numpy as np
from src.general_functions import subgradient, loss


def inner_algorithm(x, y, lambda_par, curr_meta_parameter, loss_name):

    epochs_number = 1

    n_points, n_dims = x.shape
    k = 0  # total number of iterations
    epochs_number_temp = 1
    average_cum_error = 0
    temp_weight_vectors = []
    temp_gradients = []
    all_individual_losses = []
    all_average_cum_err = []

    curr_weights = curr_meta_parameter

    shuffled_indexes = list(range(n_points))

    while epochs_number_temp <= epochs_number:

        for inner_iteration, curr_point_idx in enumerate(shuffled_indexes):

            # print(inner_iteration)

            if inner_iteration == n_points - 1:
                epochs_number_temp = epochs_number_temp + 1

            k = k + 1

            # receive a new datapoint
            curr_x = x[curr_point_idx, :]
            curr_y = y[curr_point_idx]

            # compute the loss on the next point
            regularizer = (lambda_par / 2) * np.linalg.norm(curr_weights - curr_meta_parameter, ord=2)**2

            loss_current = loss(curr_x, curr_y, curr_weights, loss_name) + regularizer
            all_individual_losses.append(loss_current)
            average_cum_error = (1 / k) * ((k - 1) * average_cum_error + loss_current)
            all_average_cum_err.append(average_cum_error)

            # compute the gradient of the regularized loss
            subgrad = subgradient(curr_x, curr_y, curr_weights, loss_name)
            full_gradient = subgrad + lambda_par * (curr_weights - curr_meta_parameter)
            temp_gradients.append(full_gradient)

            # update the inner weight vector
            curr_weights = curr_weights - (1/(lambda_par * k)) * full_gradient
            temp_weight_vectors.append(curr_weights)

    average_weights = np.mean(temp_weight_vectors, axis=0)

    return curr_weights, average_weights
