
import numpy as np


# loss function's subgradient
def subgradient(x, y, w, loss_name=None):

    # absolute loss subgradient
    if loss_name == 'absolute':
        pred = x @ w
        if y < pred:
            return x
        elif y >= pred:
            return - x
    else:
        raise ValueError("Unknown loss.")


# loss function
def loss(x, y, w, loss_name=None):

    # absolute loss
    if loss_name == 'absolute':
        pred = x @ w
        if hasattr(y, '__len__'):
            return 1 / len(y) * np.sum(np.abs(y - pred))
        else:
            return np.abs(y - pred)
    else:
        raise ValueError("Unknown loss.")


# feature map for the side information
def feature_map(x, y, feature_map_name=None, r=None, W=None):

    import math

    if feature_map_name == 'linear':
        x_transformed = np.mean(x, axis=0)
    elif feature_map_name == 'circle_feature_map':
        import math
        x_transformed = []
        x_transformed.append(math.cos(2 * x * math.pi))
        x_transformed.append(math.sin(2 * x * math.pi))
        x_transformed = np.asarray(x_transformed)
    elif feature_map_name == 'circle_fourier':
        import math
        x_transformed = np.cos(W * x + r)
        x_transformed = np.asarray(x_transformed)
        x_transformed = np.append(x_transformed, [1.])
    elif feature_map_name == 'linear_with_labels':
        if y is None:
            x_transformed = np.mean(x, axis=0)
            x_transformed = np.append(x_transformed, [1])
        else:
            n_points, n_dims = x.shape
            x_transformed = np.zeros(2 * n_dims)
            for idx_n in range(n_points):
                x_tmp = np.tensordot(x[idx_n, :], [y[idx_n], 1.], 0)
                x_transformed = x_transformed + np.ravel(x_tmp)
            x_transformed = x_transformed / n_points
            x_transformed = np.append(x_transformed, [1])
    elif feature_map_name == 'fourier_vector':
        import math
        n_points, n_dims = x.shape
        k = W.shape[0]
        x_transformed = (1 / n_points) * np.sqrt(2 / k) * np.sum(np.cos(W @ x.T + r), 1)
        x_transformed = np.append(x_transformed, np.mean(x, axis=0))
        x_transformed = np.append(x_transformed, [1.])
    else:
        raise ValueError("Unknown feature map.")

    return x_transformed
