from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import os

os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"
os.environ["CUDA_VISIBLE_DEVICES"] = ""
os.environ['KERAS_BACKEND'] = 'tensorflow'

from keras.applications import VGG16
from keras.preprocessing import image
from keras.applications.vgg16 import preprocess_input
from keras.models import Model

import tensorflow as tf
import os, sys
import numpy as np
from PIL import Image

from skimage.transform import resize
from skimage.exposure import rescale_intensity

indir = './COOS7_images/'
test_sets = ['test1', 'test2', 'test3', 'test4', 'train']
layers = ['block1_conv1', 'block1_conv2', 'block2_conv1', 'block2_conv2', 'block3_conv1', 'block3_conv2', 'block3_conv3', 
          'block4_conv1', 'block4_conv2', 'block4_conv3', 'block5_conv1', 'block5_conv2', 'block5_conv3']

for layer in layers:
    base_model = VGG16(weights='imagenet', include_top=False, input_shape=(64, 64, 3))
    model = Model(inputs=base_model.input, outputs=base_model.get_layer(layer).output)

    for test_set in test_sets:
        for directory in os.listdir(indir + test_set):
            for image in os.listdir(indir + test_set + "/" + directory):
                if ("_protein.tif" in image):
                    print("Predicting " + image)
                    x_batch = np.array(Image.open(indir + test_set + "/" + directory + "/" + image))
                    x_batch = rescale_intensity(x_batch, out_range=(0,1))
                    x_batch = resize(x_batch, output_shape=(64, 64))
                    x_batch = np.rint(x_batch * 255)

                    x_batch = np.expand_dims(x_batch, -1)
                    x_batch = np.tile(x_batch, 3)

                    x_batch = np.expand_dims(x_batch, 0)
                    x_batch = preprocess_input(x_batch, data_format='channels_last')

                    pred = model.predict(x_batch)
                    pred = np.squeeze(pred)
                    pred = np.max(pred, axis=(0, 1))
                    if not os.path.exists("./COOS7_vgg16_features/" + layer + "/"):
                         os.makedirs("./COO7_vgg16_features/" + layer + "/")

                    id = image.split("_protein")[0]
                    outputfile = "./COOS7_vgg16_features/" + layer + "/" + test_set  + ".txt"                
                    output = open(outputfile, "a")
                    output.write(directory)
                    output.write("\t")
                    output.write(id)
                    output.write("\t")
                    for feat in pred:
                        output.write(str(feat))
                        output.write("\t")
                    output.write("\n")
                    output.close()
