import sys
from bc_params_factory import default_params_for_eval, default_my_params
from bc import BenchmarkCNN
from bc_helpers import setup


def bc_eval_multi_hdf5s(model_name, hdf_files, data_format, eval_log_file):
    params = default_params_for_eval(model_name=model_name, load_ckpt=None, data_format=data_format)
    my_params = default_my_params(init_hdf5=None, eval_log_file='test_log.txt', just_compile=True)
    bc = BenchmarkCNN(params=params, my_params=my_params)
    bc.print_info()
    bc.run()

    for f in hdf_files:
        bc.load_weights_from_hdf5(f)
        bc.simple_eval('this is from {}'.format(f))




if __name__ == '__main__':
    bc_eval_multi_hdf5s('alexnet', ['test.hdf5', 'test2.hdf5'], 'NCHW', 'testlogfile.txt')





#   save it weights

#   test it

#   test several checkpoints