import numpy as np
import scipy.special
# Version of KOV optimal composition bound when each algorithm is (eps, delta = 0)-DP

# choose i to be in {0,1,..., floor(k/2)}
def delta_i_term(k,eps,i,ell):
    binom = scipy.special.binom(k,ell)
    num = np.exp((k-ell)*eps) - np.exp((k - 2*i+ell)*eps )
    denom = (1+np.exp(eps))**k
    return binom * num / denom
def opt_comp_term(k,eps,i):
    if i > k/2 or i < 0:
        print(i)
        return "Select i in {0,1,..., k/2}"
    deltas = []
    for ell in range(int(i)):
        delta_ell = delta_i_term(k,eps,i,ell)
        deltas.append(delta_ell)
    delta_i = sum(deltas)
    return ((k - 2*i)*eps,delta_i)
def opt_comp_array(k,eps):
    priv_parameters = []
    for i in range(int(np.floor(k/2))+1):
        priv_parameters.append(opt_comp_term(k,eps,i))
    return priv_parameters
def opt_comp(k,eps,delta_thresh):
    val_epsdelta = (k*eps,0.0)
    i = 0
    for i in range(1,int(np.floor(k/2))+1):
        if opt_comp_term(k,eps,i)[1] > delta_thresh:
            break
    return opt_comp_term(k,eps,max(0,i-1))
def advanced_comp_range(k,eps,delta_thresh):
    if delta_thresh <=0.0:
        return k*eps
    mean = k*eps**2/2.0
    sd = eps*np.sqrt(1.0/2.0*k*np.log(1.0/delta_thresh))
    mean_old = k*eps*(np.exp(eps)-1.0)/(np.exp(eps) + 1.0)
    sd_old = eps*np.sqrt(2.0*k*np.log(1.0/delta_thresh))
    return min(mean+sd,mean_old+sd_old, k*eps)
