import subprocess
from pygcn import load_data
import numpy as np

dataset = 'synthetic_spa'
numgraphs = 100

#for full_net, version in [(True, ''), (False, 'train'), (False, 'test'), (False, 'valid')]:
#full_net = False
full_net = True
r = 0.5
for i in range(numgraphs):
    print(i)
#    print(full_net, version)
    make_file_int = True
    
    if full_net:
        outfile = 'data/{}/{}_{:.2f}_{}.content'.format(dataset, dataset, r, i)
        infile = 'data/{}/{}_{:.2f}_{}.cites'.format(dataset, dataset, r, i)
    else:
        train_pct = '0.40'
    #    version = 'valid'
        outfile = 'data/{0}/{0}_{3:.2f}_{1}_train_{2}.content'.format(dataset, i, train_pct, r)
        infile = 'data/{0}/{0}_{3:.2f}_{1}_train_{2}.cites'.format(dataset, i, train_pct, r)
#        n = np.loadtxt('data/{}/{}.content'.format(dataset, dataset)).shape[0]
        n = 500
    
    if make_file_int:
        a = np.loadtxt(infile, dtype=int)
        np.savetxt(infile, a, fmt='%d')
    
    if full_net:
        subprocess.call('python role2vec/main.py --features motif --graph-input {0} --output {1}'.format(infile, outfile), shell=True)
    else:
        subprocess.call('python role2vec/main.py --features motif --graph-input {0} --output {1} --n {2}'.format(infile, outfile, n), shell=True)
    
    
    with open(outfile, 'r') as fin:
        data = fin.read().splitlines(True)
    with open(outfile, 'w') as fout:
        fout.writelines(data[1:])
    
    content = np.loadtxt(outfile, delimiter=',')
    b = np.zeros((content.shape[0], 1))
    order = np.argsort(content[:, 0])
    content = content[order]
    a = np.concatenate((content,b), axis=1)
    np.savetxt(outfile, a, fmt = '%d ' + '%f '*(a.shape[1]-1))