import argparse
import json
import sys
import numpy

COUNT = 'count'
OVERWEIGHT = 'overweight'
OBESE = 'obese'
NORMAL = 'normal'

config = None
num = None
out = None

# Generte distribution
def generateDistribution(dist):
    total = 0
    for name, options in dist.items():
        total += options[COUNT] 

    overweight = {}
    overweight_total = 0
    obese = {}
    obese_total = 0
    normal = {}
    normal_total = 0
    for name, options in dist.items():
        opt_perc = float(options[COUNT] * 100) / total
        overweight_perc = float(options[OVERWEIGHT] * opt_perc) / 100
        obese_perc = float(options[OBESE] * opt_perc) / 100
        overweight[name] = overweight_perc
        obese[name] = obese_perc
        normal[name] = opt_perc - overweight_perc - obese_perc
        overweight_total += overweight[name]
        obese_total += obese[name]
        normal_total += normal[name]

    return overweight, overweight_total, obese, obese_total, normal, normal_total

# The main program
if __name__ == '__main__':


    # Read parameters
    parser = argparse.ArgumentParser()
    parser.add_argument('--num', dest='num', help='The number of nodes to generate')
    parser.add_argument('--out', dest='out', help='The output file name')
    parser.add_argument('--config', dest='config', help='The output file name')
    args = parser.parse_args()

    # Validate parameters
    if args.num is None or args.out is None:
        parser.print_help()
        sys.exit(1)
    num = int(args.num)
    out = args.out
    config_file = args.config
    
    # Read configuration
    with open(config_file, 'r') as file:
        config = json.load(file)


    # Generate nodes
    dist = config['distribution']
    gender = dist['gender']
    ethnicity = dist['ethnicity']
    age = dist['age']

    g_ow, g_ow_t, g_ob, g_ob_t, g_nm, g_nm_t = generateDistribution(gender)
    e_ow, e_ow_t, e_ob, e_ob_t, e_nm, e_nm_t = generateDistribution(ethnicity)
    a_ow, a_ow_t, a_ob, a_ob_t, a_nm, a_nm_t = generateDistribution(age)

    # Combine attributes
    # test = 0
    eth_age_gen_dist = {}
    attributes = []
    probabilities = []
    for gen_name, gen_options in gender.items():
        gen_ow = g_ow[gen_name]
        gen_ob = g_ob[gen_name]
        gen_nm = g_nm[gen_name]
        for eth_name, eth_options in ethnicity.items():
            eth_ow = e_ow[eth_name]
            eth_ob = e_ob[eth_name]
            eth_nm = e_nm[eth_name]
            for age_name, age_options in age.items():
                age_ow = a_ow[age_name]
                age_ob = a_ob[age_name]
                age_nm = a_nm[age_name]

                ow_key = '{ "gender": "' + gen_name + '", "ethnicity": "' + eth_name + '", "age": "' + age_name + '", "status": "' + OVERWEIGHT + '" }'
                ow_val = float(gen_ow * eth_ow * age_ow) / 100 / g_ow_t / e_ow_t
                eth_age_gen_dist[ow_key] = ow_val
                attributes.append(ow_key)
                probabilities.append(ow_val)

                ob_key = '{ "gender": "' + gen_name + '", "ethnicity": "' + eth_name + '", "age": "' + age_name + '", "status": "' + OBESE + '" }'
                ob_val = float(gen_ob * eth_ob * age_ob) / 100 / g_ob_t / e_ob_t
                eth_age_gen_dist[ob_key] = ob_val
                attributes.append(ob_key)
                probabilities.append(ob_val)

                nm_key = '{ "gender": "' + gen_name + '", "ethnicity": "' + eth_name + '", "age": "' + age_name + '", "status": "' + NORMAL + '" }'
                nm_val = float(gen_nm * eth_nm * age_nm) / 100 / g_nm_t / e_nm_t
                eth_age_gen_dist[nm_key] = nm_val
                attributes.append(nm_key)
                probabilities.append(nm_val)

                # test += eth_age_gen_dist[gen_name + '-' + eth_name + '-' + age_name + '-' + OVERWEIGHT] + eth_age_gen_dist[gen_name + '-' + eth_name + '-' + age_name + '-' + OBESE] + eth_age_gen_dist[gen_name + '-' + eth_name + '-' + age_name + '-' + NORMAL]

    # print(test)
    # print(eth_age_gen_dist)

    # Generate nodes
    nodes = numpy.random.choice(numpy.arange(0, len(attributes)), size=num, p=probabilities)

    # Write nodes to file
    with open(out, 'w') as outfile:
        outfile.write("[")
        is_first = True
        for index in nodes:
            if not is_first:
                outfile.write(",\n")
            outfile.write(attributes[index])
            is_first = False
        outfile.write("]\n")

