#!/bin/bash
# Train sequence+structure model on top of existing structure-only model.

# SET HERE.
# Directory DB5 folder was extracted to.
DB5_DIR=
# Directory structure-only model was trained at.
MODEL_DIR=
# Directory to output results to.
OUT_DIR=

if [ -z "$DB5_DIR" ] || [ -z $MODEL_DIR ] || [ -z $OUT_DIR ] 
then
    echo "Please specify parameters in seq_train.sh first!"
    exit
fi

PSSM=$DB5_DIR/pssm/pssm.h5

TRAIN_SIZE=10240
TRAIN_FILE=$DB5_DIR/lists/DB3.txt
VAL_SIZE=4352 
VAL_FILE=$DB5_DIR/lists/DB4-update.txt

cp $MODEL_DIR/model.json $OUT_DIR/

# Configure sequence+structure model params.
python main.py config interact seqmodel $MODEL_DIR $OUT_DIR/seqmodel.json -l $OUT_DIR/seqmodel-config.log -n -d -w 2 --src pssm struct

# Configure sequence+structure training run.
python main.py config interact train $DB5_DIR/ptt/unbound_heavy6/ $TRAIN_SIZE $VAL_SIZE $OUT_DIR/train.json -l $OUT_DIR/train-config.log --loose -b 32 -r 1 -g 1  --rolls-per-pass=1 -o RMS -lr 0.001  --keep_file_training=$TRAIN_FILE --keep_file_validation=$VAL_FILE --seq_src=$PSSM

# Run sequence+structure training.
python main.py interact $OUT_DIR/model.json $OUT_DIR/train.json $OUT_DIR -q $OUT_DIR/seqmodel.json -l $OUT_DIR/seq-interact.log
