The directory contains code allowing to reproduce results presented in *Variational Bayesian Decision-making for Continuous Utilities*.


### Main files   
 - eight_schools.ipynb - Jupter Notebook illustrating VI, LCVI and LCVI-EM on The Eight Schools model.
 - matrix_factorization.ipynb - Jupter Notebook illustrating VI/LCVI/LCVI-EM on Matrix Factorization model with Last.fm data.


### Additional files   
 
 - evaluation.py - Calculation of empirical risks and gains
 - losses.py - Python code allowing to calculate losses and utilities 
 - optimal_decisions.py - Code to optimize w.r.t. decisions, both in closed-forms and numerically (M-step).
 - numerical_optimization.py - Numerical optimization of decisions 
 - utility_term_estimation.py - Python code allowing to construct various approximations of the utility-dependent term.
 - aux.py / aux_time.py / aux_plt.py - Auxiliary functions for printing, plotting, measuring time and handling PyTorch tensors.


### Data

Last.fm data can be found in *data* directory. The main file is lastfm_data.csv. 
The data was extracted using *data/lastfm_data_preparation.ipynb*.


### Pre-installation Requirements

The code was tested using Python 3.6 from Anaconda 2018.*.
It requires PyTorch 1.0, numpy, pandas, pystan, seaborn, and matplotlib to be preinstalled.


### Experiments

Experiments are placed in *experiments* directory.
Additional details can be found in *experiments/README.txt*
For each of the experiments, we provide the intermediate results that 
were used to create plots using REPORT*.ipynb Jupyter notebooks. 
Thanks to that, additional plots/processing can be achieved 
without running full experiments.
