%% set up

clear;
addpath('../aux'); %test;
addpath('../figures');
addpath('../results'); %test;

design='HLLT'; %NP, SSG, HLLT
[f,sim,x_vis,f_vis]=get_design(design);

% sample size
N=1000;

% simulate data, split into stage 1 and 2 samples
rng('default');
rho=0.5;
[x,y,z]=sim(f,N,rho);

%% sieve

df=get_basis(x,y,z,x_vis);

% initialize hyperparameters for tuning
lambda_0=log(0.05); %hyp1=lambda. log(0.05) for NP
xi_0=log(0.05); %hyp2=xi. log(0.05) for NP

% stage 1 tuning
sieve1_obj=@(lambda) sieve1_loss(df,exp(lambda)); %exp to ensure pos; fixed vx,vz
lambda_star=fminunc(sieve1_obj,lambda_0);

% stage 2 tuning
sieve2_obj=@(xi) sieve2_loss(df,[exp(lambda_star),exp(xi)]); %exp to ensure pos
xi_star=fminunc(sieve2_obj,xi_0);

% evaluate on full sample using tuned hyperparameters
y_vis=sieveIV_pred(df,[exp(lambda_star),exp(xi_star)],3); %exp to ensure pos

% mse
disp('mse:');
disp(mse(y_vis,f_vis));