#!/bin/bash
#(50 20 100)
mems=(20 50 100)
bs=10
runs=15
val=0
n_iters=1
name=cifar10

python baselines_main.py --lr 0.1 --n_epochs 5 --samples_per_task -1 --validation $val --n_runs $runs --n_iters $n_iters --name "$name iid_training"
python cer_main.py --lr 0.1 --samples_per_task -1 --validation $val --rehearsal 0 --n_runs $runs --n_iters $n_iters --name "$name single"

for mem in "${mems[@]}"
    do
        python cer_main.py --validation $val --samples_per_task -1 --buffer_batch_size $bs --n_runs $runs --n_iters $n_iters --mem_size $mem --max_loss --name "$name max_loss"
        python cer_main.py --validation $val --samples_per_task -1 --buffer_batch_size $bs --n_runs $runs --n_iters $n_iters --mem_size $mem --name "$name baseline"
        python cer_main.py --validation $val --samples_per_task -1 --buffer_batch_size $bs --n_runs $runs --n_iters $n_iters --mem_size $mem --max_loss --compare_to_old_logits --name "$name max_loss_logit"
    done


