function [ fig ] = errorbar_algorithms( stat, parameters, stds, ylabelString, xlabelString)
	global algos

	fig = figure;
	hold on
	if runAlgo('pcv')
		errorbar(parameters,stat('pcv'),stds('pcv'),'b--^','LineWidth',1.5,'MarkerSize',8);
	end
	if runAlgo('panda')
		errorbar(parameters,stat('panda'),stds('panda'),'m-*','LineWidth',1.5,'MarkerSize',8);
	end
	if runAlgo('asso')
		errorbar(parameters,stat('asso'),stds('asso'),'g-o','LineWidth',1.5,'MarkerSize',8);
	end
	if runAlgo('nassau')
		errorbar(parameters,stat('nassau'),stds('nassau'),'r-','LineWidth',1.5,'MarkerSize',8);
	end
	if runAlgo('message')
		errorbar(parameters,stat('message'),stds('message'),'k-.p','LineWidth',1.5,'MarkerSize',8);
	end
	if runAlgo('lfm')
		errorbar(parameters,stat('lfm'),stds('lfm'),'g-*','LineWidth',1.5,'MarkerSize',8);
	end
	if runAlgo('lim')
		errorbar(parameters,stat('lim'),stds('lim'),'r-','LineWidth',1.5,'MarkerSize',8);
	end

	set(gca,'FontSize',21)
	xticks(parameters);
	% xticks([0.2, 0.3, 0.4, 0.5, 0.75, 0.95]);
	ylabel(ylabelString,'Interpreter','LaTeX','FontSize',25)
	xlabel(xlabelString,'Interpreter','LaTeX','FontSize',25)
	lgd = legend(algos,'Location','best');
	lgd.FontSize = 21;
	legend boxoff;
	hold off

%	useful commands:
%
%	title('Quality of the patterns by the algorithms');
%	yticks([0,0.2,0.4,0.6,0.8,1]);

end

