import numpy
import random
import sys

from scipy.sparse.linalg import aslinearoperator
from scipy.sparse.linalg import svds

def Proj(A, k, proj='simple',gamma=0.5):
	if proj == 'simple':
		return SimpleProj(A, k)
	else:
		print('Unsupported projection method: {0}'.format(proj))
		return

def SimpleProj(A, k):
	_,n = A.shape
	svdK = min(k,n)
	
	Aop = aslinearoperator(A)
	U,_,_ = svds(Aop,svdK,return_singular_vectors='u')
	return numpy.dot( U, U.T )

