import numpy
import random

import Clustering
import Projections

''' 
	The algorithm clusters the COLUMNS of the given matrix G.

	Types of clusterings:
		- kmeans -- uses k-means algorithm
'''
def ProjCluster(G, k, tau, projection='simple', gamma=0.5, useRandomProjection=False, clustering = 'kmeans'):
	rows, columns = G.shape

	H = numpy.zeros((1,1))
	P = Projections.Proj(G, k, proj=projection, gamma=gamma)
	H = numpy.dot(P,G)

	clusters = list()
	if clustering == 'kmeans':
		clusters = Clustering.kmeans(H,tau)
	else:
		print('unknown clustering method')

	return clusters

