import numpy

def BinaryMajorityVote(B, transactionClusters, threshold=0.5, minClusterSize=1):
	clusters = list()
	for transactionCluster in transactionClusters:
		if len(transactionCluster) < minClusterSize:
			continue

		cluster = BinaryMajorityVoteSingleCluster(B[list(transactionCluster), :], threshold)
		clusters.append(cluster)

	return clusters

def BinaryMajorityVoteSingleCluster(B, threshold):
	'''
	Returns a set of all column indices where the fractions of 1s in the column
	is larger than threshold.
	'''
	columnIndices = set()

	rows,cols = B.shape

	nonzeroCountPerCol = numpy.count_nonzero(B, axis=0)
	absThreshold = rows * threshold

	for col in range(cols):
		if nonzeroCountPerCol[col] > absThreshold:
			columnIndices.add(col)

	return columnIndices

