function CN = CovNum(dm)
%CovNum - 2-approximation of the covering numbers of distance matrix dm via farthest point sampling algorithm
%
%   CN = CovNum(dm)
%           
%       CN(n) = smallest epsilon such that it was found n-points can form a epsilon-net
%       dm - distance matrix
	n = length(dm(1,:));
	landmarks = FPS(dm,n);
	CN = zeros(1,n);
	for i=1:(n-1)
		CN(i) = min(dm(landmarks(1:i),landmarks(i+1)));
	end
end
